/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityManagerAttributesResponse extends Ec2Response implements
        ToCopyableBuilder<GetCapacityManagerAttributesResponse.Builder, GetCapacityManagerAttributesResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityManagerStatus")
            .getter(getter(GetCapacityManagerAttributesResponse::capacityManagerStatusAsString))
            .setter(setter(Builder::capacityManagerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerStatus")
                    .unmarshallLocationName("capacityManagerStatus").build()).build();

    private static final SdkField<Boolean> ORGANIZATIONS_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OrganizationsAccess")
            .getter(getter(GetCapacityManagerAttributesResponse::organizationsAccess))
            .setter(setter(Builder::organizationsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsAccess")
                    .unmarshallLocationName("organizationsAccess").build()).build();

    private static final SdkField<Integer> DATA_EXPORT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataExportCount")
            .getter(getter(GetCapacityManagerAttributesResponse::dataExportCount))
            .setter(setter(Builder::dataExportCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExportCount")
                    .unmarshallLocationName("dataExportCount").build()).build();

    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IngestionStatus")
            .getter(getter(GetCapacityManagerAttributesResponse::ingestionStatusAsString))
            .setter(setter(Builder::ingestionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus")
                    .unmarshallLocationName("ingestionStatus").build()).build();

    private static final SdkField<String> INGESTION_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IngestionStatusMessage")
            .getter(getter(GetCapacityManagerAttributesResponse::ingestionStatusMessage))
            .setter(setter(Builder::ingestionStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatusMessage")
                    .unmarshallLocationName("ingestionStatusMessage").build()).build();

    private static final SdkField<Instant> EARLIEST_DATAPOINT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestDatapointTimestamp")
            .getter(getter(GetCapacityManagerAttributesResponse::earliestDatapointTimestamp))
            .setter(setter(Builder::earliestDatapointTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestDatapointTimestamp")
                    .unmarshallLocationName("earliestDatapointTimestamp").build()).build();

    private static final SdkField<Instant> LATEST_DATAPOINT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestDatapointTimestamp")
            .getter(getter(GetCapacityManagerAttributesResponse::latestDatapointTimestamp))
            .setter(setter(Builder::latestDatapointTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDatapointTimestamp")
                    .unmarshallLocationName("latestDatapointTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_STATUS_FIELD,
            ORGANIZATIONS_ACCESS_FIELD, DATA_EXPORT_COUNT_FIELD, INGESTION_STATUS_FIELD, INGESTION_STATUS_MESSAGE_FIELD,
            EARLIEST_DATAPOINT_TIMESTAMP_FIELD, LATEST_DATAPOINT_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityManagerStatus;

    private final Boolean organizationsAccess;

    private final Integer dataExportCount;

    private final String ingestionStatus;

    private final String ingestionStatusMessage;

    private final Instant earliestDatapointTimestamp;

    private final Instant latestDatapointTimestamp;

    private GetCapacityManagerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.capacityManagerStatus = builder.capacityManagerStatus;
        this.organizationsAccess = builder.organizationsAccess;
        this.dataExportCount = builder.dataExportCount;
        this.ingestionStatus = builder.ingestionStatus;
        this.ingestionStatusMessage = builder.ingestionStatusMessage;
        this.earliestDatapointTimestamp = builder.earliestDatapointTimestamp;
        this.latestDatapointTimestamp = builder.latestDatapointTimestamp;
    }

    /**
     * <p>
     * The current status of Capacity Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityManagerStatus} will return {@link CapacityManagerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capacityManagerStatusAsString}.
     * </p>
     * 
     * @return The current status of Capacity Manager.
     * @see CapacityManagerStatus
     */
    public final CapacityManagerStatus capacityManagerStatus() {
        return CapacityManagerStatus.fromValue(capacityManagerStatus);
    }

    /**
     * <p>
     * The current status of Capacity Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityManagerStatus} will return {@link CapacityManagerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capacityManagerStatusAsString}.
     * </p>
     * 
     * @return The current status of Capacity Manager.
     * @see CapacityManagerStatus
     */
    public final String capacityManagerStatusAsString() {
        return capacityManagerStatus;
    }

    /**
     * <p>
     * Indicates whether Organizations access is enabled for cross-account data aggregation.
     * </p>
     * 
     * @return Indicates whether Organizations access is enabled for cross-account data aggregation.
     */
    public final Boolean organizationsAccess() {
        return organizationsAccess;
    }

    /**
     * <p>
     * The number of active data export configurations for this account. This count includes all data exports regardless
     * of their current delivery status.
     * </p>
     * 
     * @return The number of active data export configurations for this account. This count includes all data exports
     *         regardless of their current delivery status.
     */
    public final Integer dataExportCount() {
        return dataExportCount;
    }

    /**
     * <p>
     * The current data ingestion status. Initial ingestion may take several hours after enabling Capacity Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return The current data ingestion status. Initial ingestion may take several hours after enabling Capacity
     *         Manager.
     * @see IngestionStatus
     */
    public final IngestionStatus ingestionStatus() {
        return IngestionStatus.fromValue(ingestionStatus);
    }

    /**
     * <p>
     * The current data ingestion status. Initial ingestion may take several hours after enabling Capacity Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return The current data ingestion status. Initial ingestion may take several hours after enabling Capacity
     *         Manager.
     * @see IngestionStatus
     */
    public final String ingestionStatusAsString() {
        return ingestionStatus;
    }

    /**
     * <p>
     * A descriptive message providing additional details about the current ingestion status. This may include error
     * information if ingestion has failed or progress details during initial setup.
     * </p>
     * 
     * @return A descriptive message providing additional details about the current ingestion status. This may include
     *         error information if ingestion has failed or progress details during initial setup.
     */
    public final String ingestionStatusMessage() {
        return ingestionStatusMessage;
    }

    /**
     * <p>
     * The timestamp of the earliest data point available in Capacity Manager, in milliseconds since epoch. This
     * indicates how far back historical data is available for queries.
     * </p>
     * 
     * @return The timestamp of the earliest data point available in Capacity Manager, in milliseconds since epoch. This
     *         indicates how far back historical data is available for queries.
     */
    public final Instant earliestDatapointTimestamp() {
        return earliestDatapointTimestamp;
    }

    /**
     * <p>
     * The timestamp of the most recent data point ingested by Capacity Manager, in milliseconds since epoch. This
     * indicates how current your capacity data is.
     * </p>
     * 
     * @return The timestamp of the most recent data point ingested by Capacity Manager, in milliseconds since epoch.
     *         This indicates how current your capacity data is.
     */
    public final Instant latestDatapointTimestamp() {
        return latestDatapointTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityManagerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationsAccess());
        hashCode = 31 * hashCode + Objects.hashCode(dataExportCount());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(earliestDatapointTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestDatapointTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerAttributesResponse)) {
            return false;
        }
        GetCapacityManagerAttributesResponse other = (GetCapacityManagerAttributesResponse) obj;
        return Objects.equals(capacityManagerStatusAsString(), other.capacityManagerStatusAsString())
                && Objects.equals(organizationsAccess(), other.organizationsAccess())
                && Objects.equals(dataExportCount(), other.dataExportCount())
                && Objects.equals(ingestionStatusAsString(), other.ingestionStatusAsString())
                && Objects.equals(ingestionStatusMessage(), other.ingestionStatusMessage())
                && Objects.equals(earliestDatapointTimestamp(), other.earliestDatapointTimestamp())
                && Objects.equals(latestDatapointTimestamp(), other.latestDatapointTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityManagerAttributesResponse")
                .add("CapacityManagerStatus", capacityManagerStatusAsString()).add("OrganizationsAccess", organizationsAccess())
                .add("DataExportCount", dataExportCount()).add("IngestionStatus", ingestionStatusAsString())
                .add("IngestionStatusMessage", ingestionStatusMessage())
                .add("EarliestDatapointTimestamp", earliestDatapointTimestamp())
                .add("LatestDatapointTimestamp", latestDatapointTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityManagerStatus":
            return Optional.ofNullable(clazz.cast(capacityManagerStatusAsString()));
        case "OrganizationsAccess":
            return Optional.ofNullable(clazz.cast(organizationsAccess()));
        case "DataExportCount":
            return Optional.ofNullable(clazz.cast(dataExportCount()));
        case "IngestionStatus":
            return Optional.ofNullable(clazz.cast(ingestionStatusAsString()));
        case "IngestionStatusMessage":
            return Optional.ofNullable(clazz.cast(ingestionStatusMessage()));
        case "EarliestDatapointTimestamp":
            return Optional.ofNullable(clazz.cast(earliestDatapointTimestamp()));
        case "LatestDatapointTimestamp":
            return Optional.ofNullable(clazz.cast(latestDatapointTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityManagerStatus", CAPACITY_MANAGER_STATUS_FIELD);
        map.put("OrganizationsAccess", ORGANIZATIONS_ACCESS_FIELD);
        map.put("DataExportCount", DATA_EXPORT_COUNT_FIELD);
        map.put("IngestionStatus", INGESTION_STATUS_FIELD);
        map.put("IngestionStatusMessage", INGESTION_STATUS_MESSAGE_FIELD);
        map.put("EarliestDatapointTimestamp", EARLIEST_DATAPOINT_TIMESTAMP_FIELD);
        map.put("LatestDatapointTimestamp", LATEST_DATAPOINT_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerAttributesResponse, T> g) {
        return obj -> g.apply((GetCapacityManagerAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCapacityManagerAttributesResponse> {
        /**
         * <p>
         * The current status of Capacity Manager.
         * </p>
         * 
         * @param capacityManagerStatus
         *        The current status of Capacity Manager.
         * @see CapacityManagerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerStatus
         */
        Builder capacityManagerStatus(String capacityManagerStatus);

        /**
         * <p>
         * The current status of Capacity Manager.
         * </p>
         * 
         * @param capacityManagerStatus
         *        The current status of Capacity Manager.
         * @see CapacityManagerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerStatus
         */
        Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus);

        /**
         * <p>
         * Indicates whether Organizations access is enabled for cross-account data aggregation.
         * </p>
         * 
         * @param organizationsAccess
         *        Indicates whether Organizations access is enabled for cross-account data aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationsAccess(Boolean organizationsAccess);

        /**
         * <p>
         * The number of active data export configurations for this account. This count includes all data exports
         * regardless of their current delivery status.
         * </p>
         * 
         * @param dataExportCount
         *        The number of active data export configurations for this account. This count includes all data exports
         *        regardless of their current delivery status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExportCount(Integer dataExportCount);

        /**
         * <p>
         * The current data ingestion status. Initial ingestion may take several hours after enabling Capacity Manager.
         * </p>
         * 
         * @param ingestionStatus
         *        The current data ingestion status. Initial ingestion may take several hours after enabling Capacity
         *        Manager.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder ingestionStatus(String ingestionStatus);

        /**
         * <p>
         * The current data ingestion status. Initial ingestion may take several hours after enabling Capacity Manager.
         * </p>
         * 
         * @param ingestionStatus
         *        The current data ingestion status. Initial ingestion may take several hours after enabling Capacity
         *        Manager.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder ingestionStatus(IngestionStatus ingestionStatus);

        /**
         * <p>
         * A descriptive message providing additional details about the current ingestion status. This may include error
         * information if ingestion has failed or progress details during initial setup.
         * </p>
         * 
         * @param ingestionStatusMessage
         *        A descriptive message providing additional details about the current ingestion status. This may
         *        include error information if ingestion has failed or progress details during initial setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionStatusMessage(String ingestionStatusMessage);

        /**
         * <p>
         * The timestamp of the earliest data point available in Capacity Manager, in milliseconds since epoch. This
         * indicates how far back historical data is available for queries.
         * </p>
         * 
         * @param earliestDatapointTimestamp
         *        The timestamp of the earliest data point available in Capacity Manager, in milliseconds since epoch.
         *        This indicates how far back historical data is available for queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestDatapointTimestamp(Instant earliestDatapointTimestamp);

        /**
         * <p>
         * The timestamp of the most recent data point ingested by Capacity Manager, in milliseconds since epoch. This
         * indicates how current your capacity data is.
         * </p>
         * 
         * @param latestDatapointTimestamp
         *        The timestamp of the most recent data point ingested by Capacity Manager, in milliseconds since epoch.
         *        This indicates how current your capacity data is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDatapointTimestamp(Instant latestDatapointTimestamp);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String capacityManagerStatus;

        private Boolean organizationsAccess;

        private Integer dataExportCount;

        private String ingestionStatus;

        private String ingestionStatusMessage;

        private Instant earliestDatapointTimestamp;

        private Instant latestDatapointTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerAttributesResponse model) {
            super(model);
            capacityManagerStatus(model.capacityManagerStatus);
            organizationsAccess(model.organizationsAccess);
            dataExportCount(model.dataExportCount);
            ingestionStatus(model.ingestionStatus);
            ingestionStatusMessage(model.ingestionStatusMessage);
            earliestDatapointTimestamp(model.earliestDatapointTimestamp);
            latestDatapointTimestamp(model.latestDatapointTimestamp);
        }

        public final String getCapacityManagerStatus() {
            return capacityManagerStatus;
        }

        public final void setCapacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
        }

        @Override
        public final Builder capacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
            return this;
        }

        @Override
        public final Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus) {
            this.capacityManagerStatus(capacityManagerStatus == null ? null : capacityManagerStatus.toString());
            return this;
        }

        public final Boolean getOrganizationsAccess() {
            return organizationsAccess;
        }

        public final void setOrganizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
        }

        @Override
        public final Builder organizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
            return this;
        }

        public final Integer getDataExportCount() {
            return dataExportCount;
        }

        public final void setDataExportCount(Integer dataExportCount) {
            this.dataExportCount = dataExportCount;
        }

        @Override
        public final Builder dataExportCount(Integer dataExportCount) {
            this.dataExportCount = dataExportCount;
            return this;
        }

        public final String getIngestionStatus() {
            return ingestionStatus;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final String getIngestionStatusMessage() {
            return ingestionStatusMessage;
        }

        public final void setIngestionStatusMessage(String ingestionStatusMessage) {
            this.ingestionStatusMessage = ingestionStatusMessage;
        }

        @Override
        public final Builder ingestionStatusMessage(String ingestionStatusMessage) {
            this.ingestionStatusMessage = ingestionStatusMessage;
            return this;
        }

        public final Instant getEarliestDatapointTimestamp() {
            return earliestDatapointTimestamp;
        }

        public final void setEarliestDatapointTimestamp(Instant earliestDatapointTimestamp) {
            this.earliestDatapointTimestamp = earliestDatapointTimestamp;
        }

        @Override
        public final Builder earliestDatapointTimestamp(Instant earliestDatapointTimestamp) {
            this.earliestDatapointTimestamp = earliestDatapointTimestamp;
            return this;
        }

        public final Instant getLatestDatapointTimestamp() {
            return latestDatapointTimestamp;
        }

        public final void setLatestDatapointTimestamp(Instant latestDatapointTimestamp) {
            this.latestDatapointTimestamp = latestDatapointTimestamp;
        }

        @Override
        public final Builder latestDatapointTimestamp(Instant latestDatapointTimestamp) {
            this.latestDatapointTimestamp = latestDatapointTimestamp;
            return this;
        }

        @Override
        public GetCapacityManagerAttributesResponse build() {
            return new GetCapacityManagerAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
