/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maximum period since deprecation for allowed images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprecationTimeConditionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<DeprecationTimeConditionRequest.Builder, DeprecationTimeConditionRequest> {
    private static final SdkField<Integer> MAXIMUM_DAYS_SINCE_DEPRECATED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumDaysSinceDeprecated")
            .getter(getter(DeprecationTimeConditionRequest::maximumDaysSinceDeprecated))
            .setter(setter(Builder::maximumDaysSinceDeprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDaysSinceDeprecated")
                    .unmarshallLocationName("MaximumDaysSinceDeprecated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAXIMUM_DAYS_SINCE_DEPRECATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumDaysSinceDeprecated;

    private DeprecationTimeConditionRequest(BuilderImpl builder) {
        this.maximumDaysSinceDeprecated = builder.maximumDaysSinceDeprecated;
    }

    /**
     * <p>
     * The maximum number of days that have elapsed since the image was deprecated. Set to <code>0</code> to exclude all
     * deprecated images.
     * </p>
     * 
     * @return The maximum number of days that have elapsed since the image was deprecated. Set to <code>0</code> to
     *         exclude all deprecated images.
     */
    public final Integer maximumDaysSinceDeprecated() {
        return maximumDaysSinceDeprecated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumDaysSinceDeprecated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecationTimeConditionRequest)) {
            return false;
        }
        DeprecationTimeConditionRequest other = (DeprecationTimeConditionRequest) obj;
        return Objects.equals(maximumDaysSinceDeprecated(), other.maximumDaysSinceDeprecated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprecationTimeConditionRequest")
                .add("MaximumDaysSinceDeprecated", maximumDaysSinceDeprecated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumDaysSinceDeprecated":
            return Optional.ofNullable(clazz.cast(maximumDaysSinceDeprecated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumDaysSinceDeprecated", MAXIMUM_DAYS_SINCE_DEPRECATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprecationTimeConditionRequest, T> g) {
        return obj -> g.apply((DeprecationTimeConditionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeprecationTimeConditionRequest> {
        /**
         * <p>
         * The maximum number of days that have elapsed since the image was deprecated. Set to <code>0</code> to exclude
         * all deprecated images.
         * </p>
         * 
         * @param maximumDaysSinceDeprecated
         *        The maximum number of days that have elapsed since the image was deprecated. Set to <code>0</code> to
         *        exclude all deprecated images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumDaysSinceDeprecated(Integer maximumDaysSinceDeprecated);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumDaysSinceDeprecated;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecationTimeConditionRequest model) {
            maximumDaysSinceDeprecated(model.maximumDaysSinceDeprecated);
        }

        public final Integer getMaximumDaysSinceDeprecated() {
            return maximumDaysSinceDeprecated;
        }

        public final void setMaximumDaysSinceDeprecated(Integer maximumDaysSinceDeprecated) {
            this.maximumDaysSinceDeprecated = maximumDaysSinceDeprecated;
        }

        @Override
        public final Builder maximumDaysSinceDeprecated(Integer maximumDaysSinceDeprecated) {
            this.maximumDaysSinceDeprecated = maximumDaysSinceDeprecated;
            return this;
        }

        @Override
        public DeprecationTimeConditionRequest build() {
            return new DeprecationTimeConditionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
