/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocalGatewayVirtualInterfaceRequest extends Ec2Request implements
        ToCopyableBuilder<CreateLocalGatewayVirtualInterfaceRequest.Builder, CreateLocalGatewayVirtualInterfaceRequest> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostLagId")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::outpostLagId))
            .setter(setter(Builder::outpostLagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId")
                    .unmarshallLocationName("OutpostLagId").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Vlan")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::vlan))
            .setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan")
                    .unmarshallLocationName("Vlan").build()).build();

    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalAddress")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::localAddress))
            .setter(setter(Builder::localAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress")
                    .unmarshallLocationName("LocalAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("PeerAddress").build()).build();

    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeerBgpAsn")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::peerBgpAsn))
            .setter(setter(Builder::peerBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn")
                    .unmarshallLocationName("PeerBgpAsn").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Long> PEER_BGP_ASN_EXTENDED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerBgpAsnExtended")
            .getter(getter(CreateLocalGatewayVirtualInterfaceRequest::peerBgpAsnExtended))
            .setter(setter(Builder::peerBgpAsnExtended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsnExtended")
                    .unmarshallLocationName("PeerBgpAsnExtended").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, OUTPOST_LAG_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD,
            PEER_ADDRESS_FIELD, PEER_BGP_ASN_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, PEER_BGP_ASN_EXTENDED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String localGatewayVirtualInterfaceGroupId;

    private final String outpostLagId;

    private final Integer vlan;

    private final String localAddress;

    private final String peerAddress;

    private final Integer peerBgpAsn;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean dryRun;

    private final Long peerBgpAsnExtended;

    private CreateLocalGatewayVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.outpostLagId = builder.outpostLagId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.peerBgpAsnExtended = builder.peerBgpAsnExtended;
    }

    /**
     * <p>
     * The ID of the local gateway virtual interface group.
     * </p>
     * 
     * @return The ID of the local gateway virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * References the Link Aggregation Group (LAG) that connects the Outpost to on-premises network devices.
     * </p>
     * 
     * @return References the Link Aggregation Group (LAG) that connects the Outpost to on-premises network devices.
     */
    public final String outpostLagId() {
        return outpostLagId;
    }

    /**
     * <p>
     * The virtual local area network (VLAN) used for the local gateway virtual interface.
     * </p>
     * 
     * @return The virtual local area network (VLAN) used for the local gateway virtual interface.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The IP address assigned to the local gateway virtual interface on the Outpost side. Only IPv4 is supported.
     * </p>
     * 
     * @return The IP address assigned to the local gateway virtual interface on the Outpost side. Only IPv4 is
     *         supported.
     */
    public final String localAddress() {
        return localAddress;
    }

    /**
     * <p>
     * The peer IP address for the local gateway virtual interface. Only IPv4 is supported.
     * </p>
     * 
     * @return The peer IP address for the local gateway virtual interface. Only IPv4 is supported.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The Autonomous System Number (ASN) of the Border Gateway Protocol (BGP) peer.
     * </p>
     * 
     * @return The Autonomous System Number (ASN) of the Border Gateway Protocol (BGP) peer.
     */
    public final Integer peerBgpAsn() {
        return peerBgpAsn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to a resource when the local gateway virtual interface is being created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to a resource when the local gateway virtual interface is being created.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The extended 32-bit ASN of the BGP peer for use with larger ASN values.
     * </p>
     * 
     * @return The extended 32-bit ASN of the BGP peer for use with larger ASN values.
     */
    public final Long peerBgpAsnExtended() {
        return peerBgpAsnExtended;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsnExtended());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayVirtualInterfaceRequest)) {
            return false;
        }
        CreateLocalGatewayVirtualInterfaceRequest other = (CreateLocalGatewayVirtualInterfaceRequest) obj;
        return Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(outpostLagId(), other.outpostLagId()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(localAddress(), other.localAddress()) && Objects.equals(peerAddress(), other.peerAddress())
                && Objects.equals(peerBgpAsn(), other.peerBgpAsn()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(peerBgpAsnExtended(), other.peerBgpAsnExtended());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocalGatewayVirtualInterfaceRequest")
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("OutpostLagId", outpostLagId()).add("Vlan", vlan()).add("LocalAddress", localAddress())
                .add("PeerAddress", peerAddress()).add("PeerBgpAsn", peerBgpAsn())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DryRun", dryRun())
                .add("PeerBgpAsnExtended", peerBgpAsnExtended()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "OutpostLagId":
            return Optional.ofNullable(clazz.cast(outpostLagId()));
        case "Vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "LocalAddress":
            return Optional.ofNullable(clazz.cast(localAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "PeerBgpAsn":
            return Optional.ofNullable(clazz.cast(peerBgpAsn()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "PeerBgpAsnExtended":
            return Optional.ofNullable(clazz.cast(peerBgpAsnExtended()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PeerBgpAsnExtended", PEER_BGP_ASN_EXTENDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreateLocalGatewayVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLocalGatewayVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the local gateway virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the local gateway virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * References the Link Aggregation Group (LAG) that connects the Outpost to on-premises network devices.
         * </p>
         * 
         * @param outpostLagId
         *        References the Link Aggregation Group (LAG) that connects the Outpost to on-premises network devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLagId(String outpostLagId);

        /**
         * <p>
         * The virtual local area network (VLAN) used for the local gateway virtual interface.
         * </p>
         * 
         * @param vlan
         *        The virtual local area network (VLAN) used for the local gateway virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The IP address assigned to the local gateway virtual interface on the Outpost side. Only IPv4 is supported.
         * </p>
         * 
         * @param localAddress
         *        The IP address assigned to the local gateway virtual interface on the Outpost side. Only IPv4 is
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAddress(String localAddress);

        /**
         * <p>
         * The peer IP address for the local gateway virtual interface. Only IPv4 is supported.
         * </p>
         * 
         * @param peerAddress
         *        The peer IP address for the local gateway virtual interface. Only IPv4 is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The Autonomous System Number (ASN) of the Border Gateway Protocol (BGP) peer.
         * </p>
         * 
         * @param peerBgpAsn
         *        The Autonomous System Number (ASN) of the Border Gateway Protocol (BGP) peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsn(Integer peerBgpAsn);

        /**
         * <p>
         * The tags to apply to a resource when the local gateway virtual interface is being created.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to a resource when the local gateway virtual interface is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to a resource when the local gateway virtual interface is being created.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to a resource when the local gateway virtual interface is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to a resource when the local gateway virtual interface is being created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The extended 32-bit ASN of the BGP peer for use with larger ASN values.
         * </p>
         * 
         * @param peerBgpAsnExtended
         *        The extended 32-bit ASN of the BGP peer for use with larger ASN values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsnExtended(Long peerBgpAsnExtended);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceGroupId;

        private String outpostLagId;

        private Integer vlan;

        private String localAddress;

        private String peerAddress;

        private Integer peerBgpAsn;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private Long peerBgpAsnExtended;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayVirtualInterfaceRequest model) {
            super(model);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            outpostLagId(model.outpostLagId);
            vlan(model.vlan);
            localAddress(model.localAddress);
            peerAddress(model.peerAddress);
            peerBgpAsn(model.peerBgpAsn);
            tagSpecifications(model.tagSpecifications);
            dryRun(model.dryRun);
            peerBgpAsnExtended(model.peerBgpAsnExtended);
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getOutpostLagId() {
            return outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Integer getVlan() {
            return vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getLocalAddress() {
            return localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Integer getPeerBgpAsn() {
            return peerBgpAsn;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Long getPeerBgpAsnExtended() {
            return peerBgpAsnExtended;
        }

        public final void setPeerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
        }

        @Override
        public final Builder peerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocalGatewayVirtualInterfaceRequest build() {
            return new CreateLocalGatewayVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
