/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomerGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateCustomerGatewayResponse.Builder, CreateCustomerGatewayResponse> {
    private static final SdkField<CustomerGateway> CUSTOMER_GATEWAY_FIELD = SdkField
            .<CustomerGateway> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerGateway")
            .getter(getter(CreateCustomerGatewayResponse::customerGateway))
            .setter(setter(Builder::customerGateway))
            .constructor(CustomerGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGateway")
                    .unmarshallLocationName("customerGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CustomerGateway customerGateway;

    private CreateCustomerGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateway = builder.customerGateway;
    }

    /**
     * <p>
     * Information about the customer gateway.
     * </p>
     * 
     * @return Information about the customer gateway.
     */
    public final CustomerGateway customerGateway() {
        return customerGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayResponse)) {
            return false;
        }
        CreateCustomerGatewayResponse other = (CreateCustomerGatewayResponse) obj;
        return Objects.equals(customerGateway(), other.customerGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomerGatewayResponse").add("CustomerGateway", customerGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGateway":
            return Optional.ofNullable(clazz.cast(customerGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerGateway", CUSTOMER_GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomerGatewayResponse, T> g) {
        return obj -> g.apply((CreateCustomerGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomerGatewayResponse> {
        /**
         * <p>
         * Information about the customer gateway.
         * </p>
         * 
         * @param customerGateway
         *        Information about the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateway(CustomerGateway customerGateway);

        /**
         * <p>
         * Information about the customer gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerGateway.Builder} avoiding the
         * need to create one manually via {@link CustomerGateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #customerGateway(CustomerGateway)}.
         * 
         * @param customerGateway
         *        a consumer that will call methods on {@link CustomerGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerGateway(CustomerGateway)
         */
        default Builder customerGateway(Consumer<CustomerGateway.Builder> customerGateway) {
            return customerGateway(CustomerGateway.builder().applyMutation(customerGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CustomerGateway customerGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayResponse model) {
            super(model);
            customerGateway(model.customerGateway);
        }

        public final CustomerGateway.Builder getCustomerGateway() {
            return customerGateway != null ? customerGateway.toBuilder() : null;
        }

        public final void setCustomerGateway(CustomerGateway.BuilderImpl customerGateway) {
            this.customerGateway = customerGateway != null ? customerGateway.build() : null;
        }

        @Override
        public final Builder customerGateway(CustomerGateway customerGateway) {
            this.customerGateway = customerGateway;
            return this;
        }

        @Override
        public CreateCustomerGatewayResponse build() {
            return new CreateCustomerGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
