/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Client Route Enforcement is a feature of Client VPN that helps enforce administrator defined routes on devices
 * connected through the VPN. This feature helps improve your security posture by ensuring that network traffic
 * originating from a connected client is not inadvertently sent outside the VPN tunnel.
 * </p>
 * <p>
 * Client Route Enforcement works by monitoring the route table of a connected device for routing policy changes to the
 * VPN connection. If the feature detects any VPN routing policy modifications, it will automatically force an update to
 * the route table, reverting it back to the expected route configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientRouteEnforcementOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientRouteEnforcementOptions.Builder, ClientRouteEnforcementOptions> {
    private static final SdkField<Boolean> ENFORCED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enforced")
            .getter(getter(ClientRouteEnforcementOptions::enforced))
            .setter(setter(Builder::enforced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforced")
                    .unmarshallLocationName("Enforced").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enforced;

    private ClientRouteEnforcementOptions(BuilderImpl builder) {
        this.enforced = builder.enforced;
    }

    /**
     * <p>
     * Enable or disable Client Route Enforcement. The state can either be <code>true</code> (enabled) or
     * <code>false</code> (disabled). The default is <code>false</code>.
     * </p>
     * <p>
     * Valid values: <code>true | false</code>
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return Enable or disable Client Route Enforcement. The state can either be <code>true</code> (enabled) or
     *         <code>false</code> (disabled). The default is <code>false</code>.</p>
     *         <p>
     *         Valid values: <code>true | false</code>
     *         </p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean enforced() {
        return enforced;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforced());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientRouteEnforcementOptions)) {
            return false;
        }
        ClientRouteEnforcementOptions other = (ClientRouteEnforcementOptions) obj;
        return Objects.equals(enforced(), other.enforced());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientRouteEnforcementOptions").add("Enforced", enforced()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enforced":
            return Optional.ofNullable(clazz.cast(enforced()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enforced", ENFORCED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientRouteEnforcementOptions, T> g) {
        return obj -> g.apply((ClientRouteEnforcementOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientRouteEnforcementOptions> {
        /**
         * <p>
         * Enable or disable Client Route Enforcement. The state can either be <code>true</code> (enabled) or
         * <code>false</code> (disabled). The default is <code>false</code>.
         * </p>
         * <p>
         * Valid values: <code>true | false</code>
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param enforced
         *        Enable or disable Client Route Enforcement. The state can either be <code>true</code> (enabled) or
         *        <code>false</code> (disabled). The default is <code>false</code>.</p>
         *        <p>
         *        Valid values: <code>true | false</code>
         *        </p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforced(Boolean enforced);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforced;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientRouteEnforcementOptions model) {
            enforced(model.enforced);
        }

        public final Boolean getEnforced() {
            return enforced;
        }

        public final void setEnforced(Boolean enforced) {
            this.enforced = enforced;
        }

        @Override
        public final Builder enforced(Boolean enforced) {
            this.enforced = enforced;
            return this;
        }

        @Override
        public ClientRouteEnforcementOptions build() {
            return new ClientRouteEnforcementOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
