/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityManagerDataExportsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeCapacityManagerDataExportsRequest> {
    private static final SdkField<List<String>> CAPACITY_MANAGER_DATA_EXPORT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityManagerDataExportIds").getter(DescribeCapacityManagerDataExportsRequest.getter(DescribeCapacityManagerDataExportsRequest::capacityManagerDataExportIds)).setter(DescribeCapacityManagerDataExportsRequest.setter(Builder::capacityManagerDataExportIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerDataExportId").unmarshallLocationName("CapacityManagerDataExportId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeCapacityManagerDataExportsRequest.getter(DescribeCapacityManagerDataExportsRequest::maxResults)).setter(DescribeCapacityManagerDataExportsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityManagerDataExportsRequest.getter(DescribeCapacityManagerDataExportsRequest::nextToken)).setter(DescribeCapacityManagerDataExportsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeCapacityManagerDataExportsRequest.getter(DescribeCapacityManagerDataExportsRequest::dryRun)).setter(DescribeCapacityManagerDataExportsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeCapacityManagerDataExportsRequest.getter(DescribeCapacityManagerDataExportsRequest::filters)).setter(DescribeCapacityManagerDataExportsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_DATA_EXPORT_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DRY_RUN_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityManagerDataExportsRequest.memberNameToFieldInitializer();
    private final List<String> capacityManagerDataExportIds;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean dryRun;
    private final List<Filter> filters;

    private DescribeCapacityManagerDataExportsRequest(BuilderImpl builder) {
        super(builder);
        this.capacityManagerDataExportIds = builder.capacityManagerDataExportIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
    }

    public final boolean hasCapacityManagerDataExportIds() {
        return this.capacityManagerDataExportIds != null && !(this.capacityManagerDataExportIds instanceof SdkAutoConstructList);
    }

    public final List<String> capacityManagerDataExportIds() {
        return this.capacityManagerDataExportIds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityManagerDataExportIds() ? this.capacityManagerDataExportIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityManagerDataExportsRequest)) {
            return false;
        }
        DescribeCapacityManagerDataExportsRequest other = (DescribeCapacityManagerDataExportsRequest)((Object)obj);
        return this.hasCapacityManagerDataExportIds() == other.hasCapacityManagerDataExportIds() && Objects.equals(this.capacityManagerDataExportIds(), other.capacityManagerDataExportIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityManagerDataExportsRequest").add("CapacityManagerDataExportIds", this.hasCapacityManagerDataExportIds() ? this.capacityManagerDataExportIds() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("DryRun", (Object)this.dryRun()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityManagerDataExportIds": {
                return Optional.ofNullable(clazz.cast(this.capacityManagerDataExportIds()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityManagerDataExportId", CAPACITY_MANAGER_DATA_EXPORT_IDS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityManagerDataExportsRequest, T> g) {
        return obj -> g.apply((DescribeCapacityManagerDataExportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> capacityManagerDataExportIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private Boolean dryRun;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityManagerDataExportsRequest model) {
            super(model);
            this.capacityManagerDataExportIds(model.capacityManagerDataExportIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.dryRun(model.dryRun);
            this.filters(model.filters);
        }

        public final Collection<String> getCapacityManagerDataExportIds() {
            if (this.capacityManagerDataExportIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityManagerDataExportIds;
        }

        public final void setCapacityManagerDataExportIds(Collection<String> capacityManagerDataExportIds) {
            this.capacityManagerDataExportIds = CapacityManagerDataExportIdSetCopier.copy(capacityManagerDataExportIds);
        }

        @Override
        public final Builder capacityManagerDataExportIds(Collection<String> capacityManagerDataExportIds) {
            this.capacityManagerDataExportIds = CapacityManagerDataExportIdSetCopier.copy(capacityManagerDataExportIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityManagerDataExportIds(String ... capacityManagerDataExportIds) {
            this.capacityManagerDataExportIds(Arrays.asList(capacityManagerDataExportIds));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityManagerDataExportsRequest build() {
            return new DescribeCapacityManagerDataExportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityManagerDataExportsRequest> {
        public Builder capacityManagerDataExportIds(Collection<String> var1);

        public Builder capacityManagerDataExportIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

