/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a requested IPAM policy allocation rule.
 * </p>
 * <p>
 * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource types to
 * specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP addresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPolicyAllocationRuleRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPolicyAllocationRuleRequest.Builder, IpamPolicyAllocationRuleRequest> {
    private static final SdkField<String> SOURCE_IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceIpamPoolId")
            .getter(getter(IpamPolicyAllocationRuleRequest::sourceIpamPoolId))
            .setter(setter(Builder::sourceIpamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpamPoolId")
                    .unmarshallLocationName("SourceIpamPoolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IPAM_POOL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceIpamPoolId;

    private IpamPolicyAllocationRuleRequest(BuilderImpl builder) {
        this.sourceIpamPoolId = builder.sourceIpamPoolId;
    }

    /**
     * <p>
     * The ID of the source IPAM pool for the requested allocation rule.
     * </p>
     * <p>
     * An IPAM pool is a collection of IP addresses in IPAM that can be allocated to Amazon Web Services resources.
     * </p>
     * 
     * @return The ID of the source IPAM pool for the requested allocation rule.</p>
     *         <p>
     *         An IPAM pool is a collection of IP addresses in IPAM that can be allocated to Amazon Web Services
     *         resources.
     */
    public final String sourceIpamPoolId() {
        return sourceIpamPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpamPoolId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPolicyAllocationRuleRequest)) {
            return false;
        }
        IpamPolicyAllocationRuleRequest other = (IpamPolicyAllocationRuleRequest) obj;
        return Objects.equals(sourceIpamPoolId(), other.sourceIpamPoolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPolicyAllocationRuleRequest").add("SourceIpamPoolId", sourceIpamPoolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIpamPoolId":
            return Optional.ofNullable(clazz.cast(sourceIpamPoolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceIpamPoolId", SOURCE_IPAM_POOL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPolicyAllocationRuleRequest, T> g) {
        return obj -> g.apply((IpamPolicyAllocationRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPolicyAllocationRuleRequest> {
        /**
         * <p>
         * The ID of the source IPAM pool for the requested allocation rule.
         * </p>
         * <p>
         * An IPAM pool is a collection of IP addresses in IPAM that can be allocated to Amazon Web Services resources.
         * </p>
         * 
         * @param sourceIpamPoolId
         *        The ID of the source IPAM pool for the requested allocation rule.</p>
         *        <p>
         *        An IPAM pool is a collection of IP addresses in IPAM that can be allocated to Amazon Web Services
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpamPoolId(String sourceIpamPoolId);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIpamPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPolicyAllocationRuleRequest model) {
            sourceIpamPoolId(model.sourceIpamPoolId);
        }

        public final String getSourceIpamPoolId() {
            return sourceIpamPoolId;
        }

        public final void setSourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
        }

        @Override
        public final Builder sourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        @Override
        public IpamPolicyAllocationRuleRequest build() {
            return new IpamPolicyAllocationRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
