/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayMeteringPolicyEntryRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTransitGatewayMeteringPolicyEntryRequest.Builder, CreateTransitGatewayMeteringPolicyEntryRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMeteringPolicyId")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::transitGatewayMeteringPolicyId))
            .setter(setter(Builder::transitGatewayMeteringPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicyId")
                    .unmarshallLocationName("TransitGatewayMeteringPolicyId").build()).build();

    private static final SdkField<Integer> POLICY_RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicyRuleNumber")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::policyRuleNumber))
            .setter(setter(Builder::policyRuleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuleNumber")
                    .unmarshallLocationName("PolicyRuleNumber").build()).build();

    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceTransitGatewayAttachmentId")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::sourceTransitGatewayAttachmentId))
            .setter(setter(Builder::sourceTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentId")
                    .unmarshallLocationName("SourceTransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceTransitGatewayAttachmentType")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::sourceTransitGatewayAttachmentTypeAsString))
            .setter(setter(Builder::sourceTransitGatewayAttachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentType")
                    .unmarshallLocationName("SourceTransitGatewayAttachmentType").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("SourceCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourcePortRange")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("SourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationTransitGatewayAttachmentId")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::destinationTransitGatewayAttachmentId))
            .setter(setter(Builder::destinationTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DestinationTransitGatewayAttachmentId")
                    .unmarshallLocationName("DestinationTransitGatewayAttachmentId").build()).build();

    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationTransitGatewayAttachmentType")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::destinationTransitGatewayAttachmentTypeAsString))
            .setter(setter(Builder::destinationTransitGatewayAttachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DestinationTransitGatewayAttachmentType")
                    .unmarshallLocationName("DestinationTransitGatewayAttachmentType").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPortRange")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("DestinationPortRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<String> METERED_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MeteredAccount")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::meteredAccountAsString))
            .setter(setter(Builder::meteredAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredAccount")
                    .unmarshallLocationName("MeteredAccount").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD, POLICY_RULE_NUMBER_FIELD, SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD,
            SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD, SOURCE_CIDR_BLOCK_FIELD, SOURCE_PORT_RANGE_FIELD,
            DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD,
            DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PORT_RANGE_FIELD, PROTOCOL_FIELD, METERED_ACCOUNT_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transitGatewayMeteringPolicyId;

    private final Integer policyRuleNumber;

    private final String sourceTransitGatewayAttachmentId;

    private final String sourceTransitGatewayAttachmentType;

    private final String sourceCidrBlock;

    private final String sourcePortRange;

    private final String destinationTransitGatewayAttachmentId;

    private final String destinationTransitGatewayAttachmentType;

    private final String destinationCidrBlock;

    private final String destinationPortRange;

    private final String protocol;

    private final String meteredAccount;

    private final Boolean dryRun;

    private CreateTransitGatewayMeteringPolicyEntryRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMeteringPolicyId = builder.transitGatewayMeteringPolicyId;
        this.policyRuleNumber = builder.policyRuleNumber;
        this.sourceTransitGatewayAttachmentId = builder.sourceTransitGatewayAttachmentId;
        this.sourceTransitGatewayAttachmentType = builder.sourceTransitGatewayAttachmentType;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationTransitGatewayAttachmentId = builder.destinationTransitGatewayAttachmentId;
        this.destinationTransitGatewayAttachmentType = builder.destinationTransitGatewayAttachmentType;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPortRange = builder.destinationPortRange;
        this.protocol = builder.protocol;
        this.meteredAccount = builder.meteredAccount;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the transit gateway metering policy to add the entry to.
     * </p>
     * 
     * @return The ID of the transit gateway metering policy to add the entry to.
     */
    public final String transitGatewayMeteringPolicyId() {
        return transitGatewayMeteringPolicyId;
    }

    /**
     * <p>
     * The rule number for the metering policy entry. Rules are processed in order from lowest to highest number.
     * </p>
     * 
     * @return The rule number for the metering policy entry. Rules are processed in order from lowest to highest
     *         number.
     */
    public final Integer policyRuleNumber() {
        return policyRuleNumber;
    }

    /**
     * <p>
     * The ID of the source transit gateway attachment for traffic matching.
     * </p>
     * 
     * @return The ID of the source transit gateway attachment for traffic matching.
     */
    public final String sourceTransitGatewayAttachmentId() {
        return sourceTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * The type of the source transit gateway attachment for traffic matching. Note that the <code>tgw-peering</code>
     * resource type has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the source transit gateway attachment for traffic matching. Note that the
     *         <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect,
     *         use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(sourceTransitGatewayAttachmentType);
    }

    /**
     * <p>
     * The type of the source transit gateway attachment for traffic matching. Note that the <code>tgw-peering</code>
     * resource type has been deprecated. To configure metering policies for Connect, use the transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the source transit gateway attachment for traffic matching. Note that the
     *         <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect,
     *         use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String sourceTransitGatewayAttachmentTypeAsString() {
        return sourceTransitGatewayAttachmentType;
    }

    /**
     * <p>
     * The source CIDR block for traffic matching.
     * </p>
     * 
     * @return The source CIDR block for traffic matching.
     */
    public final String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The source port range for traffic matching.
     * </p>
     * 
     * @return The source port range for traffic matching.
     */
    public final String sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The ID of the destination transit gateway attachment for traffic matching.
     * </p>
     * 
     * @return The ID of the destination transit gateway attachment for traffic matching.
     */
    public final String destinationTransitGatewayAttachmentId() {
        return destinationTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * The type of the destination transit gateway attachment for traffic matching. Note that the
     * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use the
     * transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the destination transit gateway attachment for traffic matching. Note that the
     *         <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect,
     *         use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(destinationTransitGatewayAttachmentType);
    }

    /**
     * <p>
     * The type of the destination transit gateway attachment for traffic matching. Note that the
     * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use the
     * transport attachment type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTransitGatewayAttachmentType} will return
     * {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTransitGatewayAttachmentTypeAsString}.
     * </p>
     * 
     * @return The type of the destination transit gateway attachment for traffic matching. Note that the
     *         <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect,
     *         use the transport attachment type.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String destinationTransitGatewayAttachmentTypeAsString() {
        return destinationTransitGatewayAttachmentType;
    }

    /**
     * <p>
     * The destination CIDR block for traffic matching.
     * </p>
     * 
     * @return The destination CIDR block for traffic matching.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The destination port range for traffic matching.
     * </p>
     * 
     * @return The destination port range for traffic matching.
     */
    public final String destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The protocol for traffic matching (1, 6, 17, etc.).
     * </p>
     * 
     * @return The protocol for traffic matching (1, 6, 17, etc.).
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which the metered traffic should be attributed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link TransitGatewayMeteringPayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which the metered traffic should be attributed.
     * @see TransitGatewayMeteringPayerType
     */
    public final TransitGatewayMeteringPayerType meteredAccount() {
        return TransitGatewayMeteringPayerType.fromValue(meteredAccount);
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which the metered traffic should be attributed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link TransitGatewayMeteringPayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which the metered traffic should be attributed.
     * @see TransitGatewayMeteringPayerType
     */
    public final String meteredAccountAsString() {
        return meteredAccount;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMeteringPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(meteredAccountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayMeteringPolicyEntryRequest)) {
            return false;
        }
        CreateTransitGatewayMeteringPolicyEntryRequest other = (CreateTransitGatewayMeteringPolicyEntryRequest) obj;
        return Objects.equals(transitGatewayMeteringPolicyId(), other.transitGatewayMeteringPolicyId())
                && Objects.equals(policyRuleNumber(), other.policyRuleNumber())
                && Objects.equals(sourceTransitGatewayAttachmentId(), other.sourceTransitGatewayAttachmentId())
                && Objects.equals(sourceTransitGatewayAttachmentTypeAsString(),
                        other.sourceTransitGatewayAttachmentTypeAsString())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationTransitGatewayAttachmentId(), other.destinationTransitGatewayAttachmentId())
                && Objects.equals(destinationTransitGatewayAttachmentTypeAsString(),
                        other.destinationTransitGatewayAttachmentTypeAsString())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(protocol(), other.protocol())
                && Objects.equals(meteredAccountAsString(), other.meteredAccountAsString())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayMeteringPolicyEntryRequest")
                .add("TransitGatewayMeteringPolicyId", transitGatewayMeteringPolicyId())
                .add("PolicyRuleNumber", policyRuleNumber())
                .add("SourceTransitGatewayAttachmentId", sourceTransitGatewayAttachmentId())
                .add("SourceTransitGatewayAttachmentType", sourceTransitGatewayAttachmentTypeAsString())
                .add("SourceCidrBlock", sourceCidrBlock()).add("SourcePortRange", sourcePortRange())
                .add("DestinationTransitGatewayAttachmentId", destinationTransitGatewayAttachmentId())
                .add("DestinationTransitGatewayAttachmentType", destinationTransitGatewayAttachmentTypeAsString())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("DestinationPortRange", destinationPortRange())
                .add("Protocol", protocol()).add("MeteredAccount", meteredAccountAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMeteringPolicyId":
            return Optional.ofNullable(clazz.cast(transitGatewayMeteringPolicyId()));
        case "PolicyRuleNumber":
            return Optional.ofNullable(clazz.cast(policyRuleNumber()));
        case "SourceTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(sourceTransitGatewayAttachmentId()));
        case "SourceTransitGatewayAttachmentType":
            return Optional.ofNullable(clazz.cast(sourceTransitGatewayAttachmentTypeAsString()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(destinationTransitGatewayAttachmentId()));
        case "DestinationTransitGatewayAttachmentType":
            return Optional.ofNullable(clazz.cast(destinationTransitGatewayAttachmentTypeAsString()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "MeteredAccount":
            return Optional.ofNullable(clazz.cast(meteredAccountAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayMeteringPolicyId", TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD);
        map.put("PolicyRuleNumber", POLICY_RULE_NUMBER_FIELD);
        map.put("SourceTransitGatewayAttachmentId", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("SourceTransitGatewayAttachmentType", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationTransitGatewayAttachmentId", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("DestinationTransitGatewayAttachmentType", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("MeteredAccount", METERED_ACCOUNT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayMeteringPolicyEntryRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayMeteringPolicyEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayMeteringPolicyEntryRequest> {
        /**
         * <p>
         * The ID of the transit gateway metering policy to add the entry to.
         * </p>
         * 
         * @param transitGatewayMeteringPolicyId
         *        The ID of the transit gateway metering policy to add the entry to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId);

        /**
         * <p>
         * The rule number for the metering policy entry. Rules are processed in order from lowest to highest number.
         * </p>
         * 
         * @param policyRuleNumber
         *        The rule number for the metering policy entry. Rules are processed in order from lowest to highest
         *        number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRuleNumber(Integer policyRuleNumber);

        /**
         * <p>
         * The ID of the source transit gateway attachment for traffic matching.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentId
         *        The ID of the source transit gateway attachment for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId);

        /**
         * <p>
         * The type of the source transit gateway attachment for traffic matching. Note that the
         * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use
         * the transport attachment type.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentType
         *        The type of the source transit gateway attachment for traffic matching. Note that the
         *        <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for
         *        Connect, use the transport attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder sourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType);

        /**
         * <p>
         * The type of the source transit gateway attachment for traffic matching. Note that the
         * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use
         * the transport attachment type.
         * </p>
         * 
         * @param sourceTransitGatewayAttachmentType
         *        The type of the source transit gateway attachment for traffic matching. Note that the
         *        <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for
         *        Connect, use the transport attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder sourceTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType);

        /**
         * <p>
         * The source CIDR block for traffic matching.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The source port range for traffic matching.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(String sourcePortRange);

        /**
         * <p>
         * The ID of the destination transit gateway attachment for traffic matching.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentId
         *        The ID of the destination transit gateway attachment for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId);

        /**
         * <p>
         * The type of the destination transit gateway attachment for traffic matching. Note that the
         * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use
         * the transport attachment type.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentType
         *        The type of the destination transit gateway attachment for traffic matching. Note that the
         *        <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for
         *        Connect, use the transport attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder destinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType);

        /**
         * <p>
         * The type of the destination transit gateway attachment for traffic matching. Note that the
         * <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for Connect, use
         * the transport attachment type.
         * </p>
         * 
         * @param destinationTransitGatewayAttachmentType
         *        The type of the destination transit gateway attachment for traffic matching. Note that the
         *        <code>tgw-peering</code> resource type has been deprecated. To configure metering policies for
         *        Connect, use the transport attachment type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder destinationTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType);

        /**
         * <p>
         * The destination CIDR block for traffic matching.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The destination port range for traffic matching.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range for traffic matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(String destinationPortRange);

        /**
         * <p>
         * The protocol for traffic matching (1, 6, 17, etc.).
         * </p>
         * 
         * @param protocol
         *        The protocol for traffic matching (1, 6, 17, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The Amazon Web Services account ID to which the metered traffic should be attributed.
         * </p>
         * 
         * @param meteredAccount
         *        The Amazon Web Services account ID to which the metered traffic should be attributed.
         * @see TransitGatewayMeteringPayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPayerType
         */
        Builder meteredAccount(String meteredAccount);

        /**
         * <p>
         * The Amazon Web Services account ID to which the metered traffic should be attributed.
         * </p>
         * 
         * @param meteredAccount
         *        The Amazon Web Services account ID to which the metered traffic should be attributed.
         * @see TransitGatewayMeteringPayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMeteringPayerType
         */
        Builder meteredAccount(TransitGatewayMeteringPayerType meteredAccount);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayMeteringPolicyId;

        private Integer policyRuleNumber;

        private String sourceTransitGatewayAttachmentId;

        private String sourceTransitGatewayAttachmentType;

        private String sourceCidrBlock;

        private String sourcePortRange;

        private String destinationTransitGatewayAttachmentId;

        private String destinationTransitGatewayAttachmentType;

        private String destinationCidrBlock;

        private String destinationPortRange;

        private String protocol;

        private String meteredAccount;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayMeteringPolicyEntryRequest model) {
            super(model);
            transitGatewayMeteringPolicyId(model.transitGatewayMeteringPolicyId);
            policyRuleNumber(model.policyRuleNumber);
            sourceTransitGatewayAttachmentId(model.sourceTransitGatewayAttachmentId);
            sourceTransitGatewayAttachmentType(model.sourceTransitGatewayAttachmentType);
            sourceCidrBlock(model.sourceCidrBlock);
            sourcePortRange(model.sourcePortRange);
            destinationTransitGatewayAttachmentId(model.destinationTransitGatewayAttachmentId);
            destinationTransitGatewayAttachmentType(model.destinationTransitGatewayAttachmentType);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationPortRange(model.destinationPortRange);
            protocol(model.protocol);
            meteredAccount(model.meteredAccount);
            dryRun(model.dryRun);
        }

        public final String getTransitGatewayMeteringPolicyId() {
            return transitGatewayMeteringPolicyId;
        }

        public final void setTransitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
        }

        @Override
        public final Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
            return this;
        }

        public final Integer getPolicyRuleNumber() {
            return policyRuleNumber;
        }

        public final void setPolicyRuleNumber(Integer policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
        }

        @Override
        public final Builder policyRuleNumber(Integer policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
            return this;
        }

        public final String getSourceTransitGatewayAttachmentId() {
            return sourceTransitGatewayAttachmentId;
        }

        public final void setSourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
            return this;
        }

        public final String getSourceTransitGatewayAttachmentType() {
            return sourceTransitGatewayAttachmentType;
        }

        public final void setSourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType(sourceTransitGatewayAttachmentType == null ? null
                    : sourceTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getSourcePortRange() {
            return sourcePortRange;
        }

        public final void setSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public final Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentId() {
            return destinationTransitGatewayAttachmentId;
        }

        public final void setDestinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentType() {
            return destinationTransitGatewayAttachmentType;
        }

        public final void setDestinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(
                TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType(destinationTransitGatewayAttachmentType == null ? null
                    : destinationTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPortRange() {
            return destinationPortRange;
        }

        public final void setDestinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
        }

        @Override
        public final Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getMeteredAccount() {
            return meteredAccount;
        }

        public final void setMeteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
        }

        @Override
        public final Builder meteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        @Override
        public final Builder meteredAccount(TransitGatewayMeteringPayerType meteredAccount) {
            this.meteredAccount(meteredAccount == null ? null : meteredAccount.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayMeteringPolicyEntryRequest build() {
            return new CreateTransitGatewayMeteringPolicyEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
