/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPolicyState;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMeteringPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMeteringPolicy> {
    private static final SdkField<String> TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayMeteringPolicyId").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::transitGatewayMeteringPolicyId)).setter(TransitGatewayMeteringPolicy.setter(Builder::transitGatewayMeteringPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicyId").unmarshallLocationName("transitGatewayMeteringPolicyId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::transitGatewayId)).setter(TransitGatewayMeteringPolicy.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<List<String>> MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MiddleboxAttachmentIds").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::middleboxAttachmentIds)).setter(TransitGatewayMeteringPolicy.setter(Builder::middleboxAttachmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleboxAttachmentIdSet").unmarshallLocationName("middleboxAttachmentIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::stateAsString)).setter(TransitGatewayMeteringPolicy.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> UPDATE_EFFECTIVE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateEffectiveAt").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::updateEffectiveAt)).setter(TransitGatewayMeteringPolicy.setter(Builder::updateEffectiveAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateEffectiveAt").unmarshallLocationName("updateEffectiveAt").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayMeteringPolicy.getter(TransitGatewayMeteringPolicy::tags)).setter(TransitGatewayMeteringPolicy.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, MIDDLEBOX_ATTACHMENT_IDS_FIELD, STATE_FIELD, UPDATE_EFFECTIVE_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayMeteringPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayMeteringPolicyId;
    private final String transitGatewayId;
    private final List<String> middleboxAttachmentIds;
    private final String state;
    private final Instant updateEffectiveAt;
    private final List<Tag> tags;

    private TransitGatewayMeteringPolicy(BuilderImpl builder) {
        this.transitGatewayMeteringPolicyId = builder.transitGatewayMeteringPolicyId;
        this.transitGatewayId = builder.transitGatewayId;
        this.middleboxAttachmentIds = builder.middleboxAttachmentIds;
        this.state = builder.state;
        this.updateEffectiveAt = builder.updateEffectiveAt;
        this.tags = builder.tags;
    }

    public final String transitGatewayMeteringPolicyId() {
        return this.transitGatewayMeteringPolicyId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final boolean hasMiddleboxAttachmentIds() {
        return this.middleboxAttachmentIds != null && !(this.middleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> middleboxAttachmentIds() {
        return this.middleboxAttachmentIds;
    }

    public final TransitGatewayMeteringPolicyState state() {
        return TransitGatewayMeteringPolicyState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant updateEffectiveAt() {
        return this.updateEffectiveAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMeteringPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMiddleboxAttachmentIds() ? this.middleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateEffectiveAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMeteringPolicy)) {
            return false;
        }
        TransitGatewayMeteringPolicy other = (TransitGatewayMeteringPolicy)obj;
        return Objects.equals(this.transitGatewayMeteringPolicyId(), other.transitGatewayMeteringPolicyId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && this.hasMiddleboxAttachmentIds() == other.hasMiddleboxAttachmentIds() && Objects.equals(this.middleboxAttachmentIds(), other.middleboxAttachmentIds()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.updateEffectiveAt(), other.updateEffectiveAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayMeteringPolicy").add("TransitGatewayMeteringPolicyId", (Object)this.transitGatewayMeteringPolicyId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("MiddleboxAttachmentIds", this.hasMiddleboxAttachmentIds() ? this.middleboxAttachmentIds() : null).add("State", (Object)this.stateAsString()).add("UpdateEffectiveAt", (Object)this.updateEffectiveAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMeteringPolicyId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMeteringPolicyId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "MiddleboxAttachmentIds": {
                return Optional.ofNullable(clazz.cast(this.middleboxAttachmentIds()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UpdateEffectiveAt": {
                return Optional.ofNullable(clazz.cast(this.updateEffectiveAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayMeteringPolicyId", TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("MiddleboxAttachmentIdSet", MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("UpdateEffectiveAt", UPDATE_EFFECTIVE_AT_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMeteringPolicy, T> g) {
        return obj -> g.apply((TransitGatewayMeteringPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayMeteringPolicyId;
        private String transitGatewayId;
        private List<String> middleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Instant updateEffectiveAt;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMeteringPolicy model) {
            this.transitGatewayMeteringPolicyId(model.transitGatewayMeteringPolicyId);
            this.transitGatewayId(model.transitGatewayId);
            this.middleboxAttachmentIds(model.middleboxAttachmentIds);
            this.state(model.state);
            this.updateEffectiveAt(model.updateEffectiveAt);
            this.tags(model.tags);
        }

        public final String getTransitGatewayMeteringPolicyId() {
            return this.transitGatewayMeteringPolicyId;
        }

        public final void setTransitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
        }

        @Override
        public final Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final Collection<String> getMiddleboxAttachmentIds() {
            if (this.middleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.middleboxAttachmentIds;
        }

        public final void setMiddleboxAttachmentIds(Collection<String> middleboxAttachmentIds) {
            this.middleboxAttachmentIds = ValueStringListCopier.copy(middleboxAttachmentIds);
        }

        @Override
        public final Builder middleboxAttachmentIds(Collection<String> middleboxAttachmentIds) {
            this.middleboxAttachmentIds = ValueStringListCopier.copy(middleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder middleboxAttachmentIds(String ... middleboxAttachmentIds) {
            this.middleboxAttachmentIds(Arrays.asList(middleboxAttachmentIds));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayMeteringPolicyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getUpdateEffectiveAt() {
            return this.updateEffectiveAt;
        }

        public final void setUpdateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
        }

        @Override
        public final Builder updateEffectiveAt(Instant updateEffectiveAt) {
            this.updateEffectiveAt = updateEffectiveAt;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayMeteringPolicy build() {
            return new TransitGatewayMeteringPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMeteringPolicy> {
        public Builder transitGatewayMeteringPolicyId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder middleboxAttachmentIds(Collection<String> var1);

        public Builder middleboxAttachmentIds(String ... var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayMeteringPolicyState var1);

        public Builder updateEffectiveAt(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

