/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverRulesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverRulesResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRule;

public class GetIpamPrefixListResolverRulesPublisher
implements SdkPublisher<GetIpamPrefixListResolverRulesResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamPrefixListResolverRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamPrefixListResolverRulesPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamPrefixListResolverRulesPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamPrefixListResolverRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamPrefixListResolverRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPrefixListResolverRule> rules() {
        Function<GetIpamPrefixListResolverRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamPrefixListResolverRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamPrefixListResolverRulesResponseFetcher
    implements AsyncPageFetcher<GetIpamPrefixListResolverRulesResponse> {
        private GetIpamPrefixListResolverRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamPrefixListResolverRulesResponse> nextPage(GetIpamPrefixListResolverRulesResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverRulesPublisher.this.client.getIpamPrefixListResolverRules(GetIpamPrefixListResolverRulesPublisher.this.firstRequest);
            }
            return GetIpamPrefixListResolverRulesPublisher.this.client.getIpamPrefixListResolverRules((GetIpamPrefixListResolverRulesRequest)((Object)GetIpamPrefixListResolverRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

