/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportsImageIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageUsageReportEntriesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeImageUsageReportEntriesRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageIds").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::imageIds)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPORT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportIds").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::reportIds)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::reportIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").unmarshallLocationName("ReportId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::nextToken)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::filters)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::dryRun)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeImageUsageReportEntriesRequest.getter(DescribeImageUsageReportEntriesRequest::maxResults)).setter(DescribeImageUsageReportEntriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD, REPORT_IDS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, DRY_RUN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageUsageReportEntriesRequest.memberNameToFieldInitializer();
    private final List<String> imageIds;
    private final List<String> reportIds;
    private final String nextToken;
    private final List<Filter> filters;
    private final Boolean dryRun;
    private final Integer maxResults;

    private DescribeImageUsageReportEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.reportIds = builder.reportIds;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.dryRun = builder.dryRun;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public final List<String> imageIds() {
        return this.imageIds;
    }

    public final boolean hasReportIds() {
        return this.reportIds != null && !(this.reportIds instanceof SdkAutoConstructList);
    }

    public final List<String> reportIds() {
        return this.reportIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageIds() ? this.imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportIds() ? this.reportIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageUsageReportEntriesRequest)) {
            return false;
        }
        DescribeImageUsageReportEntriesRequest other = (DescribeImageUsageReportEntriesRequest)((Object)obj);
        return this.hasImageIds() == other.hasImageIds() && Objects.equals(this.imageIds(), other.imageIds()) && this.hasReportIds() == other.hasReportIds() && Objects.equals(this.reportIds(), other.reportIds()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageUsageReportEntriesRequest").add("ImageIds", this.hasImageIds() ? this.imageIds() : null).add("ReportIds", this.hasReportIds() ? this.reportIds() : null).add("NextToken", (Object)this.nextToken()).add("Filters", this.hasFilters() ? this.filters() : null).add("DryRun", (Object)this.dryRun()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "ReportIds": {
                return Optional.ofNullable(clazz.cast(this.reportIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_IDS_FIELD);
        map.put("ReportId", REPORT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageUsageReportEntriesRequest, T> g) {
        return obj -> g.apply((DescribeImageUsageReportEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> reportIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageUsageReportEntriesRequest model) {
            super(model);
            this.imageIds(model.imageIds);
            this.reportIds(model.reportIds);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
            this.dryRun(model.dryRun);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            if (this.imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageIds;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageUsageReportsImageIdStringListCopier.copy(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageUsageReportsImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final Collection<String> getReportIds() {
            if (this.reportIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportIds;
        }

        public final void setReportIds(Collection<String> reportIds) {
            this.reportIds = ImageUsageReportIdStringListCopier.copy(reportIds);
        }

        @Override
        public final Builder reportIds(Collection<String> reportIds) {
            this.reportIds = ImageUsageReportIdStringListCopier.copy(reportIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportIds(String ... reportIds) {
            this.reportIds(Arrays.asList(reportIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageUsageReportEntriesRequest build() {
            return new DescribeImageUsageReportEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageUsageReportEntriesRequest> {
        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder reportIds(Collection<String> var1);

        public Builder reportIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

