/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyHostsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyHostsRequest> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyHostsRequest.getter(ModifyHostsRequest::autoPlacementAsString)).setter(ModifyHostsRequest.setter(Builder::autoPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement").unmarshallLocationName("autoPlacement").build()}).build();
    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyHostsRequest.getter(ModifyHostsRequest::hostIds)).setter(ModifyHostsRequest.setter(Builder::hostIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD, HOST_IDS_FIELD));
    private final String autoPlacement;
    private final List<String> hostIds;

    private ModifyHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.hostIds = builder.hostIds;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)((Object)obj);
        return Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && Objects.equals(this.hostIds(), other.hostIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifyHostsRequest").add("AutoPlacement", (Object)this.autoPlacementAsString()).add("HostIds", this.hostIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.ofNullable(clazz.cast(this.autoPlacementAsString()));
            }
            case "HostIds": {
                return Optional.ofNullable(clazz.cast(this.hostIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHostsRequest, T> g) {
        return obj -> g.apply((ModifyHostsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String autoPlacement;
        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsRequest model) {
            super(model);
            this.autoPlacement(model.autoPlacement);
            this.hostIds(model.hostIds);
        }

        public final String getAutoPlacementAsString() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHostsRequest build() {
            return new ModifyHostsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyHostsRequest> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

