/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AssociatedNetworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedTargetNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedTargetNetwork> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedTargetNetwork.getter(AssociatedTargetNetwork::networkId)).setter(AssociatedTargetNetwork.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").unmarshallLocationName("networkId").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedTargetNetwork.getter(AssociatedTargetNetwork::networkTypeAsString)).setter(AssociatedTargetNetwork.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").unmarshallLocationName("networkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NETWORK_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkId;
    private final String networkType;

    private AssociatedTargetNetwork(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkType = builder.networkType;
    }

    public String networkId() {
        return this.networkId;
    }

    public AssociatedNetworkType networkType() {
        return AssociatedNetworkType.fromValue(this.networkType);
    }

    public String networkTypeAsString() {
        return this.networkType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedTargetNetwork)) {
            return false;
        }
        AssociatedTargetNetwork other = (AssociatedTargetNetwork)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AssociatedTargetNetwork").add("NetworkId", (Object)this.networkId()).add("NetworkType", (Object)this.networkTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedTargetNetwork, T> g) {
        return obj -> g.apply((AssociatedTargetNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkId;
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedTargetNetwork model) {
            this.networkId(model.networkId);
            this.networkType(model.networkType);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkTypeAsString() {
            return this.networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AssociatedNetworkType networkType) {
            this.networkType(networkType.toString());
            return this;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        public AssociatedTargetNetwork build() {
            return new AssociatedTargetNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedTargetNetwork> {
        public Builder networkId(String var1);

        public Builder networkType(String var1);

        public Builder networkType(AssociatedNetworkType var1);
    }
}

