/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNetworkAclRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteNetworkAclRequest> {
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteNetworkAclRequest.getter(DeleteNetworkAclRequest::networkAclId)).setter(DeleteNetworkAclRequest.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").unmarshallLocationName("networkAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACL_ID_FIELD));
    private final String networkAclId;

    private DeleteNetworkAclRequest(BuilderImpl builder) {
        super(builder);
        this.networkAclId = builder.networkAclId;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclRequest)) {
            return false;
        }
        DeleteNetworkAclRequest other = (DeleteNetworkAclRequest)((Object)obj);
        return Objects.equals(this.networkAclId(), other.networkAclId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNetworkAclRequest").add("NetworkAclId", (Object)this.networkAclId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkAclRequest, T> g) {
        return obj -> g.apply((DeleteNetworkAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclRequest model) {
            super(model);
            this.networkAclId(model.networkAclId);
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkAclRequest build() {
            return new DeleteNetworkAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNetworkAclRequest> {
        public Builder networkAclId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

