/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.services.ec2.model.RestorableByStringListCopier;
import software.amazon.awssdk.services.ec2.model.SnapshotIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeSnapshotsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::filters)).setter(DescribeSnapshotsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::maxResults)).setter(DescribeSnapshotsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::nextToken)).setter(DescribeSnapshotsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<String>> OWNER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::ownerIds)).setter(DescribeSnapshotsRequest.setter(Builder::ownerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build(), ListTrait.builder().memberLocationName("Owner").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESTORABLE_BY_USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::restorableByUserIds)).setter(DescribeSnapshotsRequest.setter(Builder::restorableByUserIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableBy").unmarshallLocationName("RestorableBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::snapshotIds)).setter(DescribeSnapshotsRequest.setter(Builder::snapshotIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build(), ListTrait.builder().memberLocationName("SnapshotId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNER_IDS_FIELD, RESTORABLE_BY_USER_IDS_FIELD, SNAPSHOT_IDS_FIELD));
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> ownerIds;
    private final List<String> restorableByUserIds;
    private final List<String> snapshotIds;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerIds = builder.ownerIds;
        this.restorableByUserIds = builder.restorableByUserIds;
        this.snapshotIds = builder.snapshotIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> ownerIds() {
        return this.ownerIds;
    }

    public List<String> restorableByUserIds() {
        return this.restorableByUserIds;
    }

    public List<String> snapshotIds() {
        return this.snapshotIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.restorableByUserIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.ownerIds(), other.ownerIds()) && Objects.equals(this.restorableByUserIds(), other.restorableByUserIds()) && Objects.equals(this.snapshotIds(), other.snapshotIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSnapshotsRequest").add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OwnerIds", this.ownerIds()).add("RestorableByUserIds", this.restorableByUserIds()).add("SnapshotIds", this.snapshotIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OwnerIds": {
                return Optional.ofNullable(clazz.cast(this.ownerIds()));
            }
            case "RestorableByUserIds": {
                return Optional.ofNullable(clazz.cast(this.restorableByUserIds()));
            }
            case "SnapshotIds": {
                return Optional.ofNullable(clazz.cast(this.snapshotIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private List<String> ownerIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> restorableByUserIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.ownerIds(model.ownerIds);
            this.restorableByUserIds(model.restorableByUserIds);
            this.snapshotIds(model.snapshotIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getOwnerIds() {
            return this.ownerIds;
        }

        @Override
        public final Builder ownerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ownerIds(String ... ownerIds) {
            this.ownerIds(Arrays.asList(ownerIds));
            return this;
        }

        public final void setOwnerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
        }

        public final Collection<String> getRestorableByUserIds() {
            return this.restorableByUserIds;
        }

        @Override
        public final Builder restorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableByUserIds(String ... restorableByUserIds) {
            this.restorableByUserIds(Arrays.asList(restorableByUserIds));
            return this;
        }

        public final void setRestorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
        }

        public final Collection<String> getSnapshotIds() {
            return this.snapshotIds;
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String ... snapshotIds) {
            this.snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ownerIds(Collection<String> var1);

        public Builder ownerIds(String ... var1);

        public Builder restorableByUserIds(Collection<String> var1);

        public Builder restorableByUserIds(String ... var1);

        public Builder snapshotIds(Collection<String> var1);

        public Builder snapshotIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

