/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceDetail;
import software.amazon.awssdk.services.ec2.model.ServiceDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointServicesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::serviceNames)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::serviceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNameSet").unmarshallLocationName("serviceNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceDetail>> SERVICE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::serviceDetails)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::serviceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDetailSet").unmarshallLocationName("serviceDetailSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVpcEndpointServicesResponse.getter(DescribeVpcEndpointServicesResponse::nextToken)).setter(DescribeVpcEndpointServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMES_FIELD, SERVICE_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> serviceNames;
    private final List<ServiceDetail> serviceDetails;
    private final String nextToken;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceNames = builder.serviceNames;
        this.serviceDetails = builder.serviceDetails;
        this.nextToken = builder.nextToken;
    }

    public List<String> serviceNames() {
        return this.serviceNames;
    }

    public List<ServiceDetail> serviceDetails() {
        return this.serviceDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse)((Object)obj);
        return Objects.equals(this.serviceNames(), other.serviceNames()) && Objects.equals(this.serviceDetails(), other.serviceDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointServicesResponse").add("ServiceNames", this.serviceNames()).add("ServiceDetails", this.serviceDetails()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNames": {
                return Optional.ofNullable(clazz.cast(this.serviceNames()));
            }
            case "ServiceDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointServicesResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceDetail> serviceDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            super(model);
            this.serviceNames(model.serviceNames);
            this.serviceDetails(model.serviceDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getServiceNames() {
            return this.serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String ... serviceNames) {
            this.serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        public final Collection<ServiceDetail.Builder> getServiceDetails() {
            return this.serviceDetails != null ? (Collection)this.serviceDetails.stream().map(ServiceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceDetails(Collection<ServiceDetail> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copy(serviceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(ServiceDetail ... serviceDetails) {
            this.serviceDetails(Arrays.asList(serviceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(Consumer<ServiceDetail.Builder> ... serviceDetails) {
            this.serviceDetails(Stream.of(serviceDetails).map(c -> (ServiceDetail)((ServiceDetail.Builder)ServiceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceDetails(Collection<ServiceDetail.BuilderImpl> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copyFromBuilder(serviceDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        public Builder serviceNames(Collection<String> var1);

        public Builder serviceNames(String ... var1);

        public Builder serviceDetails(Collection<ServiceDetail> var1);

        public Builder serviceDetails(ServiceDetail ... var1);

        public Builder serviceDetails(Consumer<ServiceDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

