/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZoneAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZoneAddress> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AvailabilityZoneAddress.getter(AvailabilityZoneAddress::availabilityZone)).setter(AvailabilityZoneAddress.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(AvailabilityZoneAddress.getter(AvailabilityZoneAddress::availabilityZoneId)).setter(AvailabilityZoneAddress.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<List<String>> ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationIds").getter(AvailabilityZoneAddress.getter(AvailabilityZoneAddress::allocationIds)).setter(AvailabilityZoneAddress.setter(Builder::allocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build(), ListTrait.builder().memberLocationName("AllocationId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, ALLOCATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AvailabilityZoneAddress.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final List<String> allocationIds;

    private AvailabilityZoneAddress(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.allocationIds = builder.allocationIds;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasAllocationIds() {
        return this.allocationIds != null && !(this.allocationIds instanceof SdkAutoConstructList);
    }

    public final List<String> allocationIds() {
        return this.allocationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationIds() ? this.allocationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneAddress)) {
            return false;
        }
        AvailabilityZoneAddress other = (AvailabilityZoneAddress)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasAllocationIds() == other.hasAllocationIds() && Objects.equals(this.allocationIds(), other.allocationIds());
    }

    public final String toString() {
        return ToString.builder((String)"AvailabilityZoneAddress").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AllocationIds", this.hasAllocationIds() ? this.allocationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AllocationIds": {
                return Optional.ofNullable(clazz.cast(this.allocationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AllocationId", ALLOCATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZoneAddress, T> g) {
        return obj -> g.apply((AvailabilityZoneAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private List<String> allocationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneAddress model) {
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.allocationIds(model.allocationIds);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Collection<String> getAllocationIds() {
            if (this.allocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allocationIds;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String ... allocationIds) {
            this.allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        public AvailabilityZoneAddress build() {
            return new AvailabilityZoneAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZoneAddress> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder allocationIds(Collection<String> var1);

        public Builder allocationIds(String ... var1);
    }
}

