/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityManagerDataExportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityManagerDataExportsResponse;

public class DescribeCapacityManagerDataExportsIterable
implements SdkIterable<DescribeCapacityManagerDataExportsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityManagerDataExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityManagerDataExportsIterable(Ec2Client client, DescribeCapacityManagerDataExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityManagerDataExportsResponseFetcher();
    }

    public Iterator<DescribeCapacityManagerDataExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityManagerDataExportResponse> capacityManagerDataExports() {
        Function<DescribeCapacityManagerDataExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityManagerDataExports() != null) {
                return response.capacityManagerDataExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityManagerDataExportsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityManagerDataExportsResponse> {
        private DescribeCapacityManagerDataExportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityManagerDataExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityManagerDataExportsResponse nextPage(DescribeCapacityManagerDataExportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityManagerDataExportsIterable.this.client.describeCapacityManagerDataExports(DescribeCapacityManagerDataExportsIterable.this.firstRequest);
            }
            return DescribeCapacityManagerDataExportsIterable.this.client.describeCapacityManagerDataExports((DescribeCapacityManagerDataExportsRequest)((Object)DescribeCapacityManagerDataExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

