/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddPrefixListEntriesCopier;
import software.amazon.awssdk.services.ec2.model.AddPrefixListEntry;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RemovePrefixListEntriesCopier;
import software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyManagedPrefixListRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyManagedPrefixListRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::dryRun)).setter(ModifyManagedPrefixListRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::prefixListId)).setter(ModifyManagedPrefixListRequest.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("PrefixListId").build()}).build();
    private static final SdkField<Long> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentVersion").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::currentVersion)).setter(ModifyManagedPrefixListRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").unmarshallLocationName("CurrentVersion").build()}).build();
    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListName").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::prefixListName)).setter(ModifyManagedPrefixListRequest.setter(Builder::prefixListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName").unmarshallLocationName("PrefixListName").build()}).build();
    private static final SdkField<List<AddPrefixListEntry>> ADD_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddEntries").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::addEntries)).setter(ModifyManagedPrefixListRequest.setter(Builder::addEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddEntry").unmarshallLocationName("AddEntry").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddPrefixListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemovePrefixListEntry>> REMOVE_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveEntries").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::removeEntries)).setter(ModifyManagedPrefixListRequest.setter(Builder::removeEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEntry").unmarshallLocationName("RemoveEntry").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemovePrefixListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxEntries").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::maxEntries)).setter(ModifyManagedPrefixListRequest.setter(Builder::maxEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries").unmarshallLocationName("MaxEntries").build()}).build();
    private static final SdkField<Boolean> IPAM_PREFIX_LIST_RESOLVER_SYNC_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IpamPrefixListResolverSyncEnabled").getter(ModifyManagedPrefixListRequest.getter(ModifyManagedPrefixListRequest::ipamPrefixListResolverSyncEnabled)).setter(ModifyManagedPrefixListRequest.setter(Builder::ipamPrefixListResolverSyncEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverSyncEnabled").unmarshallLocationName("IpamPrefixListResolverSyncEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, PREFIX_LIST_ID_FIELD, CURRENT_VERSION_FIELD, PREFIX_LIST_NAME_FIELD, ADD_ENTRIES_FIELD, REMOVE_ENTRIES_FIELD, MAX_ENTRIES_FIELD, IPAM_PREFIX_LIST_RESOLVER_SYNC_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyManagedPrefixListRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String prefixListId;
    private final Long currentVersion;
    private final String prefixListName;
    private final List<AddPrefixListEntry> addEntries;
    private final List<RemovePrefixListEntry> removeEntries;
    private final Integer maxEntries;
    private final Boolean ipamPrefixListResolverSyncEnabled;

    private ModifyManagedPrefixListRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.prefixListId = builder.prefixListId;
        this.currentVersion = builder.currentVersion;
        this.prefixListName = builder.prefixListName;
        this.addEntries = builder.addEntries;
        this.removeEntries = builder.removeEntries;
        this.maxEntries = builder.maxEntries;
        this.ipamPrefixListResolverSyncEnabled = builder.ipamPrefixListResolverSyncEnabled;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final Long currentVersion() {
        return this.currentVersion;
    }

    public final String prefixListName() {
        return this.prefixListName;
    }

    public final boolean hasAddEntries() {
        return this.addEntries != null && !(this.addEntries instanceof SdkAutoConstructList);
    }

    public final List<AddPrefixListEntry> addEntries() {
        return this.addEntries;
    }

    public final boolean hasRemoveEntries() {
        return this.removeEntries != null && !(this.removeEntries instanceof SdkAutoConstructList);
    }

    public final List<RemovePrefixListEntry> removeEntries() {
        return this.removeEntries;
    }

    public final Integer maxEntries() {
        return this.maxEntries;
    }

    public final Boolean ipamPrefixListResolverSyncEnabled() {
        return this.ipamPrefixListResolverSyncEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddEntries() ? this.addEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveEntries() ? this.removeEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverSyncEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyManagedPrefixListRequest)) {
            return false;
        }
        ModifyManagedPrefixListRequest other = (ModifyManagedPrefixListRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.prefixListName(), other.prefixListName()) && this.hasAddEntries() == other.hasAddEntries() && Objects.equals(this.addEntries(), other.addEntries()) && this.hasRemoveEntries() == other.hasRemoveEntries() && Objects.equals(this.removeEntries(), other.removeEntries()) && Objects.equals(this.maxEntries(), other.maxEntries()) && Objects.equals(this.ipamPrefixListResolverSyncEnabled(), other.ipamPrefixListResolverSyncEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyManagedPrefixListRequest").add("DryRun", (Object)this.dryRun()).add("PrefixListId", (Object)this.prefixListId()).add("CurrentVersion", (Object)this.currentVersion()).add("PrefixListName", (Object)this.prefixListName()).add("AddEntries", this.hasAddEntries() ? this.addEntries() : null).add("RemoveEntries", this.hasRemoveEntries() ? this.removeEntries() : null).add("MaxEntries", (Object)this.maxEntries()).add("IpamPrefixListResolverSyncEnabled", (Object)this.ipamPrefixListResolverSyncEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "PrefixListName": {
                return Optional.ofNullable(clazz.cast(this.prefixListName()));
            }
            case "AddEntries": {
                return Optional.ofNullable(clazz.cast(this.addEntries()));
            }
            case "RemoveEntries": {
                return Optional.ofNullable(clazz.cast(this.removeEntries()));
            }
            case "MaxEntries": {
                return Optional.ofNullable(clazz.cast(this.maxEntries()));
            }
            case "IpamPrefixListResolverSyncEnabled": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverSyncEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        map.put("PrefixListName", PREFIX_LIST_NAME_FIELD);
        map.put("AddEntry", ADD_ENTRIES_FIELD);
        map.put("RemoveEntry", REMOVE_ENTRIES_FIELD);
        map.put("MaxEntries", MAX_ENTRIES_FIELD);
        map.put("IpamPrefixListResolverSyncEnabled", IPAM_PREFIX_LIST_RESOLVER_SYNC_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyManagedPrefixListRequest, T> g) {
        return obj -> g.apply((ModifyManagedPrefixListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String prefixListId;
        private Long currentVersion;
        private String prefixListName;
        private List<AddPrefixListEntry> addEntries = DefaultSdkAutoConstructList.getInstance();
        private List<RemovePrefixListEntry> removeEntries = DefaultSdkAutoConstructList.getInstance();
        private Integer maxEntries;
        private Boolean ipamPrefixListResolverSyncEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyManagedPrefixListRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.prefixListId(model.prefixListId);
            this.currentVersion(model.currentVersion);
            this.prefixListName(model.prefixListName);
            this.addEntries(model.addEntries);
            this.removeEntries(model.removeEntries);
            this.maxEntries(model.maxEntries);
            this.ipamPrefixListResolverSyncEnabled(model.ipamPrefixListResolverSyncEnabled);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final Long getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getPrefixListName() {
            return this.prefixListName;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final List<AddPrefixListEntry.Builder> getAddEntries() {
            List<AddPrefixListEntry.Builder> result = AddPrefixListEntriesCopier.copyToBuilder(this.addEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddEntries(Collection<AddPrefixListEntry.BuilderImpl> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copyFromBuilder(addEntries);
        }

        @Override
        public final Builder addEntries(Collection<AddPrefixListEntry> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copy(addEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(AddPrefixListEntry ... addEntries) {
            this.addEntries(Arrays.asList(addEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(Consumer<AddPrefixListEntry.Builder> ... addEntries) {
            this.addEntries(Stream.of(addEntries).map(c -> (AddPrefixListEntry)((AddPrefixListEntry.Builder)AddPrefixListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemovePrefixListEntry.Builder> getRemoveEntries() {
            List<RemovePrefixListEntry.Builder> result = RemovePrefixListEntriesCopier.copyToBuilder(this.removeEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveEntries(Collection<RemovePrefixListEntry.BuilderImpl> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copyFromBuilder(removeEntries);
        }

        @Override
        public final Builder removeEntries(Collection<RemovePrefixListEntry> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copy(removeEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(RemovePrefixListEntry ... removeEntries) {
            this.removeEntries(Arrays.asList(removeEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(Consumer<RemovePrefixListEntry.Builder> ... removeEntries) {
            this.removeEntries(Stream.of(removeEntries).map(c -> (RemovePrefixListEntry)((RemovePrefixListEntry.Builder)RemovePrefixListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxEntries() {
            return this.maxEntries;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public final Boolean getIpamPrefixListResolverSyncEnabled() {
            return this.ipamPrefixListResolverSyncEnabled;
        }

        public final void setIpamPrefixListResolverSyncEnabled(Boolean ipamPrefixListResolverSyncEnabled) {
            this.ipamPrefixListResolverSyncEnabled = ipamPrefixListResolverSyncEnabled;
        }

        @Override
        public final Builder ipamPrefixListResolverSyncEnabled(Boolean ipamPrefixListResolverSyncEnabled) {
            this.ipamPrefixListResolverSyncEnabled = ipamPrefixListResolverSyncEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyManagedPrefixListRequest build() {
            return new ModifyManagedPrefixListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyManagedPrefixListRequest> {
        public Builder dryRun(Boolean var1);

        public Builder prefixListId(String var1);

        public Builder currentVersion(Long var1);

        public Builder prefixListName(String var1);

        public Builder addEntries(Collection<AddPrefixListEntry> var1);

        public Builder addEntries(AddPrefixListEntry ... var1);

        public Builder addEntries(Consumer<AddPrefixListEntry.Builder> ... var1);

        public Builder removeEntries(Collection<RemovePrefixListEntry> var1);

        public Builder removeEntries(RemovePrefixListEntry ... var1);

        public Builder removeEntries(Consumer<RemovePrefixListEntry.Builder> ... var1);

        public Builder maxEntries(Integer var1);

        public Builder ipamPrefixListResolverSyncEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

