/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamScopeExternalAuthorityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalAuthorityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalAuthorityConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ExternalAuthorityConfiguration.getter(ExternalAuthorityConfiguration::typeAsString)).setter(ExternalAuthorityConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<String> EXTERNAL_RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalResourceIdentifier").getter(ExternalAuthorityConfiguration.getter(ExternalAuthorityConfiguration::externalResourceIdentifier)).setter(ExternalAuthorityConfiguration.setter(Builder::externalResourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalResourceIdentifier").unmarshallLocationName("ExternalResourceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EXTERNAL_RESOURCE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalAuthorityConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String externalResourceIdentifier;

    private ExternalAuthorityConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.externalResourceIdentifier = builder.externalResourceIdentifier;
    }

    public final IpamScopeExternalAuthorityType type() {
        return IpamScopeExternalAuthorityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String externalResourceIdentifier() {
        return this.externalResourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalResourceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAuthorityConfiguration)) {
            return false;
        }
        ExternalAuthorityConfiguration other = (ExternalAuthorityConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.externalResourceIdentifier(), other.externalResourceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalAuthorityConfiguration").add("Type", (Object)this.typeAsString()).add("ExternalResourceIdentifier", (Object)this.externalResourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ExternalResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.externalResourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Type", TYPE_FIELD);
        map.put("ExternalResourceIdentifier", EXTERNAL_RESOURCE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalAuthorityConfiguration, T> g) {
        return obj -> g.apply((ExternalAuthorityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String externalResourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalAuthorityConfiguration model) {
            this.type(model.type);
            this.externalResourceIdentifier(model.externalResourceIdentifier);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IpamScopeExternalAuthorityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getExternalResourceIdentifier() {
            return this.externalResourceIdentifier;
        }

        public final void setExternalResourceIdentifier(String externalResourceIdentifier) {
            this.externalResourceIdentifier = externalResourceIdentifier;
        }

        @Override
        public final Builder externalResourceIdentifier(String externalResourceIdentifier) {
            this.externalResourceIdentifier = externalResourceIdentifier;
            return this;
        }

        public ExternalAuthorityConfiguration build() {
            return new ExternalAuthorityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalAuthorityConfiguration> {
        public Builder type(String var1);

        public Builder type(IpamScopeExternalAuthorityType var1);

        public Builder externalResourceIdentifier(String var1);
    }
}

