/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDimension;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDimensionsRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDimensionsResponse;

public class GetCapacityManagerMetricDimensionsPublisher
implements SdkPublisher<GetCapacityManagerMetricDimensionsResponse> {
    private final Ec2AsyncClient client;
    private final GetCapacityManagerMetricDimensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCapacityManagerMetricDimensionsPublisher(Ec2AsyncClient client, GetCapacityManagerMetricDimensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCapacityManagerMetricDimensionsPublisher(Ec2AsyncClient client, GetCapacityManagerMetricDimensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCapacityManagerMetricDimensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCapacityManagerMetricDimensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityManagerDimension> metricDimensionResults() {
        Function<GetCapacityManagerMetricDimensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDimensionResults() != null) {
                return response.metricDimensionResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCapacityManagerMetricDimensionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCapacityManagerMetricDimensionsResponseFetcher
    implements AsyncPageFetcher<GetCapacityManagerMetricDimensionsResponse> {
        private GetCapacityManagerMetricDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(GetCapacityManagerMetricDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCapacityManagerMetricDimensionsResponse> nextPage(GetCapacityManagerMetricDimensionsResponse previousPage) {
            if (previousPage == null) {
                return GetCapacityManagerMetricDimensionsPublisher.this.client.getCapacityManagerMetricDimensions(GetCapacityManagerMetricDimensionsPublisher.this.firstRequest);
            }
            return GetCapacityManagerMetricDimensionsPublisher.this.client.getCapacityManagerMetricDimensions((GetCapacityManagerMetricDimensionsRequest)((Object)GetCapacityManagerMetricDimensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

