/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterByDimension {
    RESOURCE_REGION("resource-region"),
    AVAILABILITY_ZONE_ID("availability-zone-id"),
    ACCOUNT_ID("account-id"),
    INSTANCE_FAMILY("instance-family"),
    INSTANCE_TYPE("instance-type"),
    INSTANCE_PLATFORM("instance-platform"),
    RESERVATION_ARN("reservation-arn"),
    RESERVATION_ID("reservation-id"),
    RESERVATION_TYPE("reservation-type"),
    RESERVATION_CREATE_TIMESTAMP("reservation-create-timestamp"),
    RESERVATION_START_TIMESTAMP("reservation-start-timestamp"),
    RESERVATION_END_TIMESTAMP("reservation-end-timestamp"),
    RESERVATION_END_DATE_TYPE("reservation-end-date-type"),
    TENANCY("tenancy"),
    RESERVATION_STATE("reservation-state"),
    RESERVATION_INSTANCE_MATCH_CRITERIA("reservation-instance-match-criteria"),
    RESERVATION_UNUSED_FINANCIAL_OWNER("reservation-unused-financial-owner"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterByDimension> VALUE_MAP;
    private final String value;

    private FilterByDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterByDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterByDimension> knownValues() {
        EnumSet<FilterByDimension> knownValues = EnumSet.allOf(FilterByDimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterByDimension.class, FilterByDimension::toString);
    }
}

