/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddressFamily;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequest;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequestSetCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamPrefixListResolverRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateIpamPrefixListResolverRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::dryRun)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::ipamId)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("IpamId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::description)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::addressFamilyAsString)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("AddressFamily").build()}).build();
    private static final SdkField<List<IpamPrefixListResolverRuleRequest>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::rules)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").unmarshallLocationName("Rule").build(), ListTrait.builder().memberLocationName("Rule").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPrefixListResolverRuleRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").unmarshallLocationName("Rule").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::tagSpecifications)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIpamPrefixListResolverRequest.getter(CreateIpamPrefixListResolverRequest::clientToken)).setter(CreateIpamPrefixListResolverRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD, DESCRIPTION_FIELD, ADDRESS_FAMILY_FIELD, RULES_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIpamPrefixListResolverRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamId;
    private final String description;
    private final String addressFamily;
    private final List<IpamPrefixListResolverRuleRequest> rules;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;

    private CreateIpamPrefixListResolverRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.description = builder.description;
        this.addressFamily = builder.addressFamily;
        this.rules = builder.rules;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String description() {
        return this.description;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<IpamPrefixListResolverRuleRequest> rules() {
        return this.rules;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverRequest)) {
            return false;
        }
        CreateIpamPrefixListResolverRequest other = (CreateIpamPrefixListResolverRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamPrefixListResolverRequest").add("DryRun", (Object)this.dryRun()).add("IpamId", (Object)this.ipamId()).add("Description", (Object)this.description()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("Rules", this.hasRules() ? this.rules() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddressFamily", ADDRESS_FAMILY_FIELD);
        map.put("Rule", RULES_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverRequest, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamId;
        private String description;
        private String addressFamily;
        private List<IpamPrefixListResolverRuleRequest> rules = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamId(model.ipamId);
            this.description(model.description);
            this.addressFamily(model.addressFamily);
            this.rules(model.rules);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final List<IpamPrefixListResolverRuleRequest.Builder> getRules() {
            List<IpamPrefixListResolverRuleRequest.Builder> result = IpamPrefixListResolverRuleRequestSetCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<IpamPrefixListResolverRuleRequest.BuilderImpl> rules) {
            this.rules = IpamPrefixListResolverRuleRequestSetCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<IpamPrefixListResolverRuleRequest> rules) {
            this.rules = IpamPrefixListResolverRuleRequestSetCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(IpamPrefixListResolverRuleRequest ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<IpamPrefixListResolverRuleRequest.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (IpamPrefixListResolverRuleRequest)((IpamPrefixListResolverRuleRequest.Builder)IpamPrefixListResolverRuleRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverRequest build() {
            return new CreateIpamPrefixListResolverRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamPrefixListResolverRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamId(String var1);

        public Builder description(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder rules(Collection<IpamPrefixListResolverRuleRequest> var1);

        public Builder rules(IpamPrefixListResolverRuleRequest ... var1);

        public Builder rules(Consumer<IpamPrefixListResolverRuleRequest.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

