/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RequestSpotFleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSpotFleetRequest extends Ec2Request implements
        ToCopyableBuilder<RequestSpotFleetRequest.Builder, RequestSpotFleetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RequestSpotFleetRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<SpotFleetRequestConfigData> SPOT_FLEET_REQUEST_CONFIG_FIELD = SdkField
            .<SpotFleetRequestConfigData> builder(MarshallingType.SDK_POJO)
            .memberName("SpotFleetRequestConfig")
            .getter(getter(RequestSpotFleetRequest::spotFleetRequestConfig))
            .setter(setter(Builder::spotFleetRequestConfig))
            .constructor(SpotFleetRequestConfigData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfig")
                    .unmarshallLocationName("spotFleetRequestConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            SPOT_FLEET_REQUEST_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private RequestSpotFleetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The configuration for the Spot Fleet request.
     * </p>
     * 
     * @return The configuration for the Spot Fleet request.
     */
    public final SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetRequest)) {
            return false;
        }
        RequestSpotFleetRequest other = (RequestSpotFleetRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(spotFleetRequestConfig(), other.spotFleetRequestConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestSpotFleetRequest").add("DryRun", dryRun())
                .add("SpotFleetRequestConfig", spotFleetRequestConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SpotFleetRequestConfig":
            return Optional.ofNullable(clazz.cast(spotFleetRequestConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SpotFleetRequestConfig", SPOT_FLEET_REQUEST_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotFleetRequest, T> g) {
        return obj -> g.apply((RequestSpotFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RequestSpotFleetRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The configuration for the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        The configuration for the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);

        /**
         * <p>
         * The configuration for the Spot Fleet request.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotFleetRequestConfigData.Builder}
         * avoiding the need to create one manually via {@link SpotFleetRequestConfigData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotFleetRequestConfigData.Builder#build()} is called immediately
         * and its result is passed to {@link #spotFleetRequestConfig(SpotFleetRequestConfigData)}.
         * 
         * @param spotFleetRequestConfig
         *        a consumer that will call methods on {@link SpotFleetRequestConfigData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotFleetRequestConfig(SpotFleetRequestConfigData)
         */
        default Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return spotFleetRequestConfig(SpotFleetRequestConfigData.builder().applyMutation(spotFleetRequestConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetRequest model) {
            super(model);
            dryRun(model.dryRun);
            spotFleetRequestConfig(model.spotFleetRequestConfig);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return spotFleetRequestConfig != null ? spotFleetRequestConfig.toBuilder() : null;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotFleetRequest build() {
            return new RequestSpotFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
