/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a request to assign billing of the unused capacity of a Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationBillingRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationBillingRequest.Builder, CapacityReservationBillingRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityReservationBillingRequest::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestedBy")
            .getter(getter(CapacityReservationBillingRequest::requestedBy))
            .setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy")
                    .unmarshallLocationName("requestedBy").build()).build();

    private static final SdkField<String> UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UnusedReservationBillingOwnerId")
            .getter(getter(CapacityReservationBillingRequest::unusedReservationBillingOwnerId))
            .setter(setter(Builder::unusedReservationBillingOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedReservationBillingOwnerId")
                    .unmarshallLocationName("unusedReservationBillingOwnerId").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime")
            .getter(getter(CapacityReservationBillingRequest::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime")
                    .unmarshallLocationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(CapacityReservationBillingRequest::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(CapacityReservationBillingRequest::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<CapacityReservationInfo> CAPACITY_RESERVATION_INFO_FIELD = SdkField
            .<CapacityReservationInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationInfo")
            .getter(getter(CapacityReservationBillingRequest::capacityReservationInfo))
            .setter(setter(Builder::capacityReservationInfo))
            .constructor(CapacityReservationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationInfo")
                    .unmarshallLocationName("capacityReservationInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            REQUESTED_BY_FIELD, UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, CAPACITY_RESERVATION_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String requestedBy;

    private final String unusedReservationBillingOwnerId;

    private final Instant lastUpdateTime;

    private final String status;

    private final String statusMessage;

    private final CapacityReservationInfo capacityReservationInfo;

    private CapacityReservationBillingRequest(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.requestedBy = builder.requestedBy;
        this.unusedReservationBillingOwnerId = builder.unusedReservationBillingOwnerId;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.capacityReservationInfo = builder.capacityReservationInfo;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that initiated the request.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that initiated the request.
     */
    public final String requestedBy() {
        return requestedBy;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account to which the request was sent.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account to which the request was sent.
     */
    public final String unusedReservationBillingOwnerId() {
        return unusedReservationBillingOwnerId;
    }

    /**
     * <p>
     * The date and time, in UTC time format, at which the request was initiated.
     * </p>
     * 
     * @return The date and time, in UTC time format, at which the request was initiated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing assignment
     * requests for a shared Amazon EC2 Capacity Reservation</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityReservationBillingRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
     *         assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
     * @see CapacityReservationBillingRequestStatus
     */
    public final CapacityReservationBillingRequestStatus status() {
        return CapacityReservationBillingRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing assignment
     * requests for a shared Amazon EC2 Capacity Reservation</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityReservationBillingRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
     *         assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
     * @see CapacityReservationBillingRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the status.
     * </p>
     * 
     * @return Information about the status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Information about the Capacity Reservation.
     * </p>
     * 
     * @return Information about the Capacity Reservation.
     */
    public final CapacityReservationInfo capacityReservationInfo() {
        return capacityReservationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(unusedReservationBillingOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationBillingRequest)) {
            return false;
        }
        CapacityReservationBillingRequest other = (CapacityReservationBillingRequest) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(requestedBy(), other.requestedBy())
                && Objects.equals(unusedReservationBillingOwnerId(), other.unusedReservationBillingOwnerId())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(capacityReservationInfo(), other.capacityReservationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationBillingRequest").add("CapacityReservationId", capacityReservationId())
                .add("RequestedBy", requestedBy()).add("UnusedReservationBillingOwnerId", unusedReservationBillingOwnerId())
                .add("LastUpdateTime", lastUpdateTime()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("CapacityReservationInfo", capacityReservationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "RequestedBy":
            return Optional.ofNullable(clazz.cast(requestedBy()));
        case "UnusedReservationBillingOwnerId":
            return Optional.ofNullable(clazz.cast(unusedReservationBillingOwnerId()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CapacityReservationInfo":
            return Optional.ofNullable(clazz.cast(capacityReservationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("RequestedBy", REQUESTED_BY_FIELD);
        map.put("UnusedReservationBillingOwnerId", UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CapacityReservationInfo", CAPACITY_RESERVATION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationBillingRequest, T> g) {
        return obj -> g.apply((CapacityReservationBillingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationBillingRequest> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that initiated the request.
         * </p>
         * 
         * @param requestedBy
         *        The ID of the Amazon Web Services account that initiated the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * The ID of the Amazon Web Services account to which the request was sent.
         * </p>
         * 
         * @param unusedReservationBillingOwnerId
         *        The ID of the Amazon Web Services account to which the request was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedReservationBillingOwnerId(String unusedReservationBillingOwnerId);

        /**
         * <p>
         * The date and time, in UTC time format, at which the request was initiated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time, in UTC time format, at which the request was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the request. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
         * assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
         * </p>
         * 
         * @param status
         *        The status of the request. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
         *        assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
         * @see CapacityReservationBillingRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationBillingRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
         * assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
         * </p>
         * 
         * @param status
         *        The status of the request. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/view-billing-transfers.html"> View billing
         *        assignment requests for a shared Amazon EC2 Capacity Reservation</a>.
         * @see CapacityReservationBillingRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationBillingRequestStatus
         */
        Builder status(CapacityReservationBillingRequestStatus status);

        /**
         * <p>
         * Information about the status.
         * </p>
         * 
         * @param statusMessage
         *        Information about the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Information about the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationInfo
         *        Information about the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationInfo(CapacityReservationInfo capacityReservationInfo);

        /**
         * <p>
         * Information about the Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationInfo.Builder} avoiding
         * the need to create one manually via {@link CapacityReservationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityReservationInfo(CapacityReservationInfo)}.
         * 
         * @param capacityReservationInfo
         *        a consumer that will call methods on {@link CapacityReservationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationInfo(CapacityReservationInfo)
         */
        default Builder capacityReservationInfo(Consumer<CapacityReservationInfo.Builder> capacityReservationInfo) {
            return capacityReservationInfo(CapacityReservationInfo.builder().applyMutation(capacityReservationInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String requestedBy;

        private String unusedReservationBillingOwnerId;

        private Instant lastUpdateTime;

        private String status;

        private String statusMessage;

        private CapacityReservationInfo capacityReservationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationBillingRequest model) {
            capacityReservationId(model.capacityReservationId);
            requestedBy(model.requestedBy);
            unusedReservationBillingOwnerId(model.unusedReservationBillingOwnerId);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
            statusMessage(model.statusMessage);
            capacityReservationInfo(model.capacityReservationInfo);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getUnusedReservationBillingOwnerId() {
            return unusedReservationBillingOwnerId;
        }

        public final void setUnusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
        }

        @Override
        public final Builder unusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityReservationBillingRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final CapacityReservationInfo.Builder getCapacityReservationInfo() {
            return capacityReservationInfo != null ? capacityReservationInfo.toBuilder() : null;
        }

        public final void setCapacityReservationInfo(CapacityReservationInfo.BuilderImpl capacityReservationInfo) {
            this.capacityReservationInfo = capacityReservationInfo != null ? capacityReservationInfo.build() : null;
        }

        @Override
        public final Builder capacityReservationInfo(CapacityReservationInfo capacityReservationInfo) {
            this.capacityReservationInfo = capacityReservationInfo;
            return this;
        }

        @Override
        public CapacityReservationBillingRequest build() {
            return new CapacityReservationBillingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
