/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidrSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamDiscoveredResourceCidrsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamDiscoveredResourceCidrsResponse> {
    private static final SdkField<List<IpamDiscoveredResourceCidr>> IPAM_DISCOVERED_RESOURCE_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamDiscoveredResourceCidrs").getter(GetIpamDiscoveredResourceCidrsResponse.getter(GetIpamDiscoveredResourceCidrsResponse::ipamDiscoveredResourceCidrs)).setter(GetIpamDiscoveredResourceCidrsResponse.setter(Builder::ipamDiscoveredResourceCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamDiscoveredResourceCidrSet").unmarshallLocationName("ipamDiscoveredResourceCidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamDiscoveredResourceCidr::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamDiscoveredResourceCidrsResponse.getter(GetIpamDiscoveredResourceCidrsResponse::nextToken)).setter(GetIpamDiscoveredResourceCidrsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_DISCOVERED_RESOURCE_CIDRS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamDiscoveredResourceCidrsResponse.memberNameToFieldInitializer();
    private final List<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs;
    private final String nextToken;

    private GetIpamDiscoveredResourceCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamDiscoveredResourceCidrs = builder.ipamDiscoveredResourceCidrs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamDiscoveredResourceCidrs() {
        return this.ipamDiscoveredResourceCidrs != null && !(this.ipamDiscoveredResourceCidrs instanceof SdkAutoConstructList);
    }

    public final List<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs() {
        return this.ipamDiscoveredResourceCidrs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamDiscoveredResourceCidrs() ? this.ipamDiscoveredResourceCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamDiscoveredResourceCidrsResponse)) {
            return false;
        }
        GetIpamDiscoveredResourceCidrsResponse other = (GetIpamDiscoveredResourceCidrsResponse)((Object)obj);
        return this.hasIpamDiscoveredResourceCidrs() == other.hasIpamDiscoveredResourceCidrs() && Objects.equals(this.ipamDiscoveredResourceCidrs(), other.ipamDiscoveredResourceCidrs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamDiscoveredResourceCidrsResponse").add("IpamDiscoveredResourceCidrs", this.hasIpamDiscoveredResourceCidrs() ? this.ipamDiscoveredResourceCidrs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamDiscoveredResourceCidrs": {
                return Optional.ofNullable(clazz.cast(this.ipamDiscoveredResourceCidrs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamDiscoveredResourceCidrSet", IPAM_DISCOVERED_RESOURCE_CIDRS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamDiscoveredResourceCidrsResponse, T> g) {
        return obj -> g.apply((GetIpamDiscoveredResourceCidrsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamDiscoveredResourceCidrsResponse model) {
            super(model);
            this.ipamDiscoveredResourceCidrs(model.ipamDiscoveredResourceCidrs);
            this.nextToken(model.nextToken);
        }

        public final List<IpamDiscoveredResourceCidr.Builder> getIpamDiscoveredResourceCidrs() {
            List<IpamDiscoveredResourceCidr.Builder> result = IpamDiscoveredResourceCidrSetCopier.copyToBuilder(this.ipamDiscoveredResourceCidrs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamDiscoveredResourceCidrs(Collection<IpamDiscoveredResourceCidr.BuilderImpl> ipamDiscoveredResourceCidrs) {
            this.ipamDiscoveredResourceCidrs = IpamDiscoveredResourceCidrSetCopier.copyFromBuilder(ipamDiscoveredResourceCidrs);
        }

        @Override
        public final Builder ipamDiscoveredResourceCidrs(Collection<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs) {
            this.ipamDiscoveredResourceCidrs = IpamDiscoveredResourceCidrSetCopier.copy(ipamDiscoveredResourceCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredResourceCidrs(IpamDiscoveredResourceCidr ... ipamDiscoveredResourceCidrs) {
            this.ipamDiscoveredResourceCidrs(Arrays.asList(ipamDiscoveredResourceCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredResourceCidrs(Consumer<IpamDiscoveredResourceCidr.Builder> ... ipamDiscoveredResourceCidrs) {
            this.ipamDiscoveredResourceCidrs(Stream.of(ipamDiscoveredResourceCidrs).map(c -> (IpamDiscoveredResourceCidr)((IpamDiscoveredResourceCidr.Builder)IpamDiscoveredResourceCidr.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamDiscoveredResourceCidrsResponse build() {
            return new GetIpamDiscoveredResourceCidrsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamDiscoveredResourceCidrsResponse> {
        public Builder ipamDiscoveredResourceCidrs(Collection<IpamDiscoveredResourceCidr> var1);

        public Builder ipamDiscoveredResourceCidrs(IpamDiscoveredResourceCidr ... var1);

        public Builder ipamDiscoveredResourceCidrs(Consumer<IpamDiscoveredResourceCidr.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

