/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup;

public class DescribeLocalGatewayVirtualInterfaceGroupsPublisher
implements SdkPublisher<DescribeLocalGatewayVirtualInterfaceGroupsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLocalGatewayVirtualInterfaceGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLocalGatewayVirtualInterfaceGroupsPublisher(Ec2AsyncClient client, DescribeLocalGatewayVirtualInterfaceGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLocalGatewayVirtualInterfaceGroupsPublisher(Ec2AsyncClient client, DescribeLocalGatewayVirtualInterfaceGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLocalGatewayVirtualInterfaceGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLocalGatewayVirtualInterfaceGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGatewayVirtualInterfaceGroup> localGatewayVirtualInterfaceGroups() {
        Function<DescribeLocalGatewayVirtualInterfaceGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGatewayVirtualInterfaceGroups() != null) {
                return response.localGatewayVirtualInterfaceGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLocalGatewayVirtualInterfaceGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLocalGatewayVirtualInterfaceGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeLocalGatewayVirtualInterfaceGroupsResponse> {
        private DescribeLocalGatewayVirtualInterfaceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayVirtualInterfaceGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLocalGatewayVirtualInterfaceGroupsResponse> nextPage(DescribeLocalGatewayVirtualInterfaceGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayVirtualInterfaceGroupsPublisher.this.client.describeLocalGatewayVirtualInterfaceGroups(DescribeLocalGatewayVirtualInterfaceGroupsPublisher.this.firstRequest);
            }
            return DescribeLocalGatewayVirtualInterfaceGroupsPublisher.this.client.describeLocalGatewayVirtualInterfaceGroups((DescribeLocalGatewayVirtualInterfaceGroupsRequest)((Object)DescribeLocalGatewayVirtualInterfaceGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

