/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseCapacityBlockResponse extends Ec2Response implements
        ToCopyableBuilder<PurchaseCapacityBlockResponse.Builder, PurchaseCapacityBlockResponse> {
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservation")
            .getter(getter(PurchaseCapacityBlockResponse::capacityReservation))
            .setter(setter(Builder::capacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation")
                    .unmarshallLocationName("capacityReservation").build()).build();

    private static final SdkField<List<CapacityBlock>> CAPACITY_BLOCKS_FIELD = SdkField
            .<List<CapacityBlock>> builder(MarshallingType.LIST)
            .memberName("CapacityBlocks")
            .getter(getter(PurchaseCapacityBlockResponse::capacityBlocks))
            .setter(setter(Builder::capacityBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockSet")
                    .unmarshallLocationName("capacityBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FIELD,
            CAPACITY_BLOCKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CapacityReservation capacityReservation;

    private final List<CapacityBlock> capacityBlocks;

    private PurchaseCapacityBlockResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservation = builder.capacityReservation;
        this.capacityBlocks = builder.capacityBlocks;
    }

    /**
     * <p>
     * The Capacity Reservation.
     * </p>
     * 
     * @return The Capacity Reservation.
     */
    public final CapacityReservation capacityReservation() {
        return capacityReservation;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityBlocks() {
        return capacityBlocks != null && !(capacityBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Capacity Block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityBlocks} method.
     * </p>
     * 
     * @return The Capacity Block.
     */
    public final List<CapacityBlock> capacityBlocks() {
        return capacityBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityBlocks() ? capacityBlocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseCapacityBlockResponse)) {
            return false;
        }
        PurchaseCapacityBlockResponse other = (PurchaseCapacityBlockResponse) obj;
        return Objects.equals(capacityReservation(), other.capacityReservation())
                && hasCapacityBlocks() == other.hasCapacityBlocks() && Objects.equals(capacityBlocks(), other.capacityBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseCapacityBlockResponse").add("CapacityReservation", capacityReservation())
                .add("CapacityBlocks", hasCapacityBlocks() ? capacityBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservation":
            return Optional.ofNullable(clazz.cast(capacityReservation()));
        case "CapacityBlocks":
            return Optional.ofNullable(clazz.cast(capacityBlocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        map.put("CapacityBlockSet", CAPACITY_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseCapacityBlockResponse, T> g) {
        return obj -> g.apply((PurchaseCapacityBlockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseCapacityBlockResponse> {
        /**
         * <p>
         * The Capacity Reservation.
         * </p>
         * 
         * @param capacityReservation
         *        The Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservation(CapacityReservation capacityReservation);

        /**
         * <p>
         * The Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityReservation(CapacityReservation)}.
         * 
         * @param capacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservation(CapacityReservation)
         */
        default Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return capacityReservation(CapacityReservation.builder().applyMutation(capacityReservation).build());
        }

        /**
         * <p>
         * The Capacity Block.
         * </p>
         * 
         * @param capacityBlocks
         *        The Capacity Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlocks(Collection<CapacityBlock> capacityBlocks);

        /**
         * <p>
         * The Capacity Block.
         * </p>
         * 
         * @param capacityBlocks
         *        The Capacity Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlocks(CapacityBlock... capacityBlocks);

        /**
         * <p>
         * The Capacity Block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlock.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.CapacityBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #capacityBlocks(List<CapacityBlock>)}.
         * 
         * @param capacityBlocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityBlocks(java.util.Collection<CapacityBlock>)
         */
        Builder capacityBlocks(Consumer<CapacityBlock.Builder>... capacityBlocks);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CapacityReservation capacityReservation;

        private List<CapacityBlock> capacityBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseCapacityBlockResponse model) {
            super(model);
            capacityReservation(model.capacityReservation);
            capacityBlocks(model.capacityBlocks);
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return capacityReservation != null ? capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        public final List<CapacityBlock.Builder> getCapacityBlocks() {
            List<CapacityBlock.Builder> result = CapacityBlockSetCopier.copyToBuilder(this.capacityBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlocks(Collection<CapacityBlock.BuilderImpl> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copyFromBuilder(capacityBlocks);
        }

        @Override
        public final Builder capacityBlocks(Collection<CapacityBlock> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copy(capacityBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(CapacityBlock... capacityBlocks) {
            capacityBlocks(Arrays.asList(capacityBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(Consumer<CapacityBlock.Builder>... capacityBlocks) {
            capacityBlocks(Stream.of(capacityBlocks).map(c -> CapacityBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PurchaseCapacityBlockResponse build() {
            return new PurchaseCapacityBlockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
