/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Outpost link aggregation group (LAG).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutpostLag implements SdkPojo, Serializable, ToCopyableBuilder<OutpostLag.Builder, OutpostLag> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(OutpostLag::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(OutpostLag::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(OutpostLag::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostLagId")
            .getter(getter(OutpostLag::outpostLagId))
            .setter(setter(Builder::outpostLagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId")
                    .unmarshallLocationName("outpostLagId").build()).build();

    private static final SdkField<List<String>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LocalGatewayVirtualInterfaceIds")
            .getter(getter(OutpostLag::localGatewayVirtualInterfaceIds))
            .setter(setter(Builder::localGatewayVirtualInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceIdSet")
                    .unmarshallLocationName("localGatewayVirtualInterfaceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ServiceLinkVirtualInterfaceIds")
            .getter(getter(OutpostLag::serviceLinkVirtualInterfaceIds))
            .setter(setter(Builder::serviceLinkVirtualInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceIdSet")
                    .unmarshallLocationName("serviceLinkVirtualInterfaceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(OutpostLag::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD,
            OWNER_ID_FIELD, STATE_FIELD, OUTPOST_LAG_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD,
            SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outpostArn;

    private final String ownerId;

    private final String state;

    private final String outpostLagId;

    private final List<String> localGatewayVirtualInterfaceIds;

    private final List<String> serviceLinkVirtualInterfaceIds;

    private final List<Tag> tags;

    private OutpostLag(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.outpostLagId = builder.outpostLagId;
        this.localGatewayVirtualInterfaceIds = builder.localGatewayVirtualInterfaceIds;
        this.serviceLinkVirtualInterfaceIds = builder.serviceLinkVirtualInterfaceIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the Outpost LAG.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the Outpost LAG.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the Outpost LAG owner.
     * </p>
     * 
     * @return The ID of the Outpost LAG owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The current state of the Outpost LAG.
     * </p>
     * 
     * @return The current state of the Outpost LAG.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the Outpost LAG.
     * </p>
     * 
     * @return The ID of the Outpost LAG.
     */
    public final String outpostLagId() {
        return outpostLagId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalGatewayVirtualInterfaceIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasLocalGatewayVirtualInterfaceIds() {
        return localGatewayVirtualInterfaceIds != null && !(localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalGatewayVirtualInterfaceIds}
     * method.
     * </p>
     * 
     * @return The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
     */
    public final List<String> localGatewayVirtualInterfaceIds() {
        return localGatewayVirtualInterfaceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceLinkVirtualInterfaceIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasServiceLinkVirtualInterfaceIds() {
        return serviceLinkVirtualInterfaceIds != null && !(serviceLinkVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The service link virtual interface IDs associated with the Outpost LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceLinkVirtualInterfaceIds} method.
     * </p>
     * 
     * @return The service link virtual interface IDs associated with the Outpost LAG.
     */
    public final List<String> serviceLinkVirtualInterfaceIds() {
        return serviceLinkVirtualInterfaceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the Outpost LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the Outpost LAG.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(outpostLagId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLocalGatewayVirtualInterfaceIds() ? localGatewayVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServiceLinkVirtualInterfaceIds() ? serviceLinkVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostLag)) {
            return false;
        }
        OutpostLag other = (OutpostLag) obj;
        return Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(state(), other.state()) && Objects.equals(outpostLagId(), other.outpostLagId())
                && hasLocalGatewayVirtualInterfaceIds() == other.hasLocalGatewayVirtualInterfaceIds()
                && Objects.equals(localGatewayVirtualInterfaceIds(), other.localGatewayVirtualInterfaceIds())
                && hasServiceLinkVirtualInterfaceIds() == other.hasServiceLinkVirtualInterfaceIds()
                && Objects.equals(serviceLinkVirtualInterfaceIds(), other.serviceLinkVirtualInterfaceIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OutpostLag")
                .add("OutpostArn", outpostArn())
                .add("OwnerId", ownerId())
                .add("State", state())
                .add("OutpostLagId", outpostLagId())
                .add("LocalGatewayVirtualInterfaceIds",
                        hasLocalGatewayVirtualInterfaceIds() ? localGatewayVirtualInterfaceIds() : null)
                .add("ServiceLinkVirtualInterfaceIds",
                        hasServiceLinkVirtualInterfaceIds() ? serviceLinkVirtualInterfaceIds() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "OutpostLagId":
            return Optional.ofNullable(clazz.cast(outpostLagId()));
        case "LocalGatewayVirtualInterfaceIds":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceIds()));
        case "ServiceLinkVirtualInterfaceIds":
            return Optional.ofNullable(clazz.cast(serviceLinkVirtualInterfaceIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceIdSet", LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD);
        map.put("ServiceLinkVirtualInterfaceIdSet", SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutpostLag, T> g) {
        return obj -> g.apply((OutpostLag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutpostLag> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the Outpost LAG.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Number (ARN) of the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the Outpost LAG owner.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Outpost LAG owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The current state of the Outpost LAG.
         * </p>
         * 
         * @param state
         *        The current state of the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The ID of the Outpost LAG.
         * </p>
         * 
         * @param outpostLagId
         *        The ID of the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLagId(String outpostLagId);

        /**
         * <p>
         * The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the local gateway virtual interfaces associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The service link virtual interface IDs associated with the Outpost LAG.
         * </p>
         * 
         * @param serviceLinkVirtualInterfaceIds
         *        The service link virtual interface IDs associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkVirtualInterfaceIds(Collection<String> serviceLinkVirtualInterfaceIds);

        /**
         * <p>
         * The service link virtual interface IDs associated with the Outpost LAG.
         * </p>
         * 
         * @param serviceLinkVirtualInterfaceIds
         *        The service link virtual interface IDs associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkVirtualInterfaceIds(String... serviceLinkVirtualInterfaceIds);

        /**
         * <p>
         * The tags associated with the Outpost LAG.
         * </p>
         * 
         * @param tags
         *        The tags associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the Outpost LAG.
         * </p>
         * 
         * @param tags
         *        The tags associated with the Outpost LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the Outpost LAG.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String outpostArn;

        private String ownerId;

        private String state;

        private String outpostLagId;

        private List<String> localGatewayVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> serviceLinkVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostLag model) {
            outpostArn(model.outpostArn);
            ownerId(model.ownerId);
            state(model.state);
            outpostLagId(model.outpostLagId);
            localGatewayVirtualInterfaceIds(model.localGatewayVirtualInterfaceIds);
            serviceLinkVirtualInterfaceIds(model.serviceLinkVirtualInterfaceIds);
            tags(model.tags);
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getOutpostLagId() {
            return outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Collection<String> getLocalGatewayVirtualInterfaceIds() {
            if (localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return localGatewayVirtualInterfaceIds;
        }

        public final void setLocalGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
        }

        @Override
        public final Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds) {
            localGatewayVirtualInterfaceIds(Arrays.asList(localGatewayVirtualInterfaceIds));
            return this;
        }

        public final Collection<String> getServiceLinkVirtualInterfaceIds() {
            if (serviceLinkVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceLinkVirtualInterfaceIds;
        }

        public final void setServiceLinkVirtualInterfaceIds(Collection<String> serviceLinkVirtualInterfaceIds) {
            this.serviceLinkVirtualInterfaceIds = ServiceLinkVirtualInterfaceIdSetCopier.copy(serviceLinkVirtualInterfaceIds);
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceIds(Collection<String> serviceLinkVirtualInterfaceIds) {
            this.serviceLinkVirtualInterfaceIds = ServiceLinkVirtualInterfaceIdSetCopier.copy(serviceLinkVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceLinkVirtualInterfaceIds(String... serviceLinkVirtualInterfaceIds) {
            serviceLinkVirtualInterfaceIds(Arrays.asList(serviceLinkVirtualInterfaceIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OutpostLag build() {
            return new OutpostLag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
