/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouteServerRoutingDatabaseResponse extends Ec2Response implements
        ToCopyableBuilder<GetRouteServerRoutingDatabaseResponse.Builder, GetRouteServerRoutingDatabaseResponse> {
    private static final SdkField<Boolean> ARE_ROUTES_PERSISTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AreRoutesPersisted")
            .getter(getter(GetRouteServerRoutingDatabaseResponse::areRoutesPersisted))
            .setter(setter(Builder::areRoutesPersisted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreRoutesPersisted")
                    .unmarshallLocationName("areRoutesPersisted").build()).build();

    private static final SdkField<List<RouteServerRoute>> ROUTES_FIELD = SdkField
            .<List<RouteServerRoute>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(GetRouteServerRoutingDatabaseResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet")
                    .unmarshallLocationName("routeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteServerRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteServerRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetRouteServerRoutingDatabaseResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARE_ROUTES_PERSISTED_FIELD,
            ROUTES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean areRoutesPersisted;

    private final List<RouteServerRoute> routes;

    private final String nextToken;

    private GetRouteServerRoutingDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.areRoutesPersisted = builder.areRoutesPersisted;
        this.routes = builder.routes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether routes are being persisted in the routing database.
     * </p>
     * 
     * @return Indicates whether routes are being persisted in the routing database.
     */
    public final Boolean areRoutesPersisted() {
        return areRoutesPersisted;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of routes in the route server's routing database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The collection of routes in the route server's routing database.
     */
    public final List<RouteServerRoute> routes() {
        return routes;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(areRoutesPersisted());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteServerRoutingDatabaseResponse)) {
            return false;
        }
        GetRouteServerRoutingDatabaseResponse other = (GetRouteServerRoutingDatabaseResponse) obj;
        return Objects.equals(areRoutesPersisted(), other.areRoutesPersisted()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouteServerRoutingDatabaseResponse").add("AreRoutesPersisted", areRoutesPersisted())
                .add("Routes", hasRoutes() ? routes() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreRoutesPersisted":
            return Optional.ofNullable(clazz.cast(areRoutesPersisted()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AreRoutesPersisted", ARE_ROUTES_PERSISTED_FIELD);
        map.put("RouteSet", ROUTES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouteServerRoutingDatabaseResponse, T> g) {
        return obj -> g.apply((GetRouteServerRoutingDatabaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRouteServerRoutingDatabaseResponse> {
        /**
         * <p>
         * Indicates whether routes are being persisted in the routing database.
         * </p>
         * 
         * @param areRoutesPersisted
         *        Indicates whether routes are being persisted in the routing database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areRoutesPersisted(Boolean areRoutesPersisted);

        /**
         * <p>
         * The collection of routes in the route server's routing database.
         * </p>
         * 
         * @param routes
         *        The collection of routes in the route server's routing database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<RouteServerRoute> routes);

        /**
         * <p>
         * The collection of routes in the route server's routing database.
         * </p>
         * 
         * @param routes
         *        The collection of routes in the route server's routing database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(RouteServerRoute... routes);

        /**
         * <p>
         * The collection of routes in the route server's routing database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerRoute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RouteServerRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerRoute.Builder#build()} is called immediately and
         * its result is passed to {@link #routes(List<RouteServerRoute>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RouteServerRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<RouteServerRoute>)
         */
        Builder routes(Consumer<RouteServerRoute.Builder>... routes);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean areRoutesPersisted;

        private List<RouteServerRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteServerRoutingDatabaseResponse model) {
            super(model);
            areRoutesPersisted(model.areRoutesPersisted);
            routes(model.routes);
            nextToken(model.nextToken);
        }

        public final Boolean getAreRoutesPersisted() {
            return areRoutesPersisted;
        }

        public final void setAreRoutesPersisted(Boolean areRoutesPersisted) {
            this.areRoutesPersisted = areRoutesPersisted;
        }

        @Override
        public final Builder areRoutesPersisted(Boolean areRoutesPersisted) {
            this.areRoutesPersisted = areRoutesPersisted;
            return this;
        }

        public final List<RouteServerRoute.Builder> getRoutes() {
            List<RouteServerRoute.Builder> result = RouteServerRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteServerRoute.BuilderImpl> routes) {
            this.routes = RouteServerRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteServerRoute> routes) {
            this.routes = RouteServerRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteServerRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteServerRoute.Builder>... routes) {
            routes(Stream.of(routes).map(c -> RouteServerRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetRouteServerRoutingDatabaseResponse build() {
            return new GetRouteServerRoutingDatabaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
