/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceTpmEkPubRequest extends Ec2Request implements
        ToCopyableBuilder<GetInstanceTpmEkPubRequest.Builder, GetInstanceTpmEkPubRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(GetInstanceTpmEkPubRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyType")
            .getter(getter(GetInstanceTpmEkPubRequest::keyTypeAsString))
            .setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType")
                    .unmarshallLocationName("KeyType").build()).build();

    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyFormat")
            .getter(getter(GetInstanceTpmEkPubRequest::keyFormatAsString))
            .setter(setter(Builder::keyFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFormat")
                    .unmarshallLocationName("KeyFormat").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(GetInstanceTpmEkPubRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            KEY_TYPE_FIELD, KEY_FORMAT_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String keyType;

    private final String keyFormat;

    private final Boolean dryRun;

    private GetInstanceTpmEkPubRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.keyType = builder.keyType;
        this.keyFormat = builder.keyFormat;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the instance for which to get the public endorsement key.
     * </p>
     * 
     * @return The ID of the instance for which to get the public endorsement key.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The required public endorsement key type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link EkPubKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The required public endorsement key type.
     * @see EkPubKeyType
     */
    public final EkPubKeyType keyType() {
        return EkPubKeyType.fromValue(keyType);
    }

    /**
     * <p>
     * The required public endorsement key type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link EkPubKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The required public endorsement key type.
     * @see EkPubKeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    /**
     * <p>
     * The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
     * compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with tpm2-tools. The
     * returned key is base64 encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyFormat} will
     * return {@link EkPubKeyFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyFormatAsString}.
     * </p>
     * 
     * @return The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
     *         compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with
     *         tpm2-tools. The returned key is base64 encoded.
     * @see EkPubKeyFormat
     */
    public final EkPubKeyFormat keyFormat() {
        return EkPubKeyFormat.fromValue(keyFormat);
    }

    /**
     * <p>
     * The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
     * compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with tpm2-tools. The
     * returned key is base64 encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyFormat} will
     * return {@link EkPubKeyFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyFormatAsString}.
     * </p>
     * 
     * @return The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
     *         compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with
     *         tpm2-tools. The returned key is base64 encoded.
     * @see EkPubKeyFormat
     */
    public final String keyFormatAsString() {
        return keyFormat;
    }

    /**
     * <p>
     * Specify this parameter to verify whether the request will succeed, without actually making the request. If the
     * request will succeed, the response is <code>DryRunOperation</code>. Otherwise, the response is
     * <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Specify this parameter to verify whether the request will succeed, without actually making the request.
     *         If the request will succeed, the response is <code>DryRunOperation</code>. Otherwise, the response is
     *         <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceTpmEkPubRequest)) {
            return false;
        }
        GetInstanceTpmEkPubRequest other = (GetInstanceTpmEkPubRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(keyTypeAsString(), other.keyTypeAsString())
                && Objects.equals(keyFormatAsString(), other.keyFormatAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceTpmEkPubRequest").add("InstanceId", instanceId()).add("KeyType", keyTypeAsString())
                .add("KeyFormat", keyFormatAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "KeyFormat":
            return Optional.ofNullable(clazz.cast(keyFormatAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("KeyType", KEY_TYPE_FIELD);
        map.put("KeyFormat", KEY_FORMAT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceTpmEkPubRequest, T> g) {
        return obj -> g.apply((GetInstanceTpmEkPubRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceTpmEkPubRequest> {
        /**
         * <p>
         * The ID of the instance for which to get the public endorsement key.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance for which to get the public endorsement key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The required public endorsement key type.
         * </p>
         * 
         * @param keyType
         *        The required public endorsement key type.
         * @see EkPubKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EkPubKeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * The required public endorsement key type.
         * </p>
         * 
         * @param keyType
         *        The required public endorsement key type.
         * @see EkPubKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EkPubKeyType
         */
        Builder keyType(EkPubKeyType keyType);

        /**
         * <p>
         * The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
         * compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with tpm2-tools.
         * The returned key is base64 encoded.
         * </p>
         * 
         * @param keyFormat
         *        The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that
         *        is compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with
         *        tpm2-tools. The returned key is base64 encoded.
         * @see EkPubKeyFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EkPubKeyFormat
         */
        Builder keyFormat(String keyFormat);

        /**
         * <p>
         * The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is
         * compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with tpm2-tools.
         * The returned key is base64 encoded.
         * </p>
         * 
         * @param keyFormat
         *        The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that
         *        is compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with
         *        tpm2-tools. The returned key is base64 encoded.
         * @see EkPubKeyFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EkPubKeyFormat
         */
        Builder keyFormat(EkPubKeyFormat keyFormat);

        /**
         * <p>
         * Specify this parameter to verify whether the request will succeed, without actually making the request. If
         * the request will succeed, the response is <code>DryRunOperation</code>. Otherwise, the response is
         * <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Specify this parameter to verify whether the request will succeed, without actually making the
         *        request. If the request will succeed, the response is <code>DryRunOperation</code>. Otherwise, the
         *        response is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private String keyType;

        private String keyFormat;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceTpmEkPubRequest model) {
            super(model);
            instanceId(model.instanceId);
            keyType(model.keyType);
            keyFormat(model.keyFormat);
            dryRun(model.dryRun);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getKeyType() {
            return keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(EkPubKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getKeyFormat() {
            return keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        @Override
        public final Builder keyFormat(EkPubKeyFormat keyFormat) {
            this.keyFormat(keyFormat == null ? null : keyFormat.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceTpmEkPubRequest build() {
            return new GetInstanceTpmEkPubRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
