/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConversionTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeConversionTasksResponse.Builder, DescribeConversionTasksResponse> {
    private static final SdkField<List<ConversionTask>> CONVERSION_TASKS_FIELD = SdkField
            .<List<ConversionTask>> builder(MarshallingType.LIST)
            .memberName("ConversionTasks")
            .getter(getter(DescribeConversionTasksResponse::conversionTasks))
            .setter(setter(Builder::conversionTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionTasks")
                    .unmarshallLocationName("conversionTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ConversionTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConversionTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_TASKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConversionTask> conversionTasks;

    private DescribeConversionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.conversionTasks = builder.conversionTasks;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConversionTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConversionTasks() {
        return conversionTasks != null && !(conversionTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the conversion tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConversionTasks} method.
     * </p>
     * 
     * @return Information about the conversion tasks.
     */
    public final List<ConversionTask> conversionTasks() {
        return conversionTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConversionTasks() ? conversionTasks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksResponse)) {
            return false;
        }
        DescribeConversionTasksResponse other = (DescribeConversionTasksResponse) obj;
        return hasConversionTasks() == other.hasConversionTasks() && Objects.equals(conversionTasks(), other.conversionTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConversionTasksResponse")
                .add("ConversionTasks", hasConversionTasks() ? conversionTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTasks":
            return Optional.ofNullable(clazz.cast(conversionTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConversionTasks", CONVERSION_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConversionTasksResponse, T> g) {
        return obj -> g.apply((DescribeConversionTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConversionTasksResponse> {
        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * 
         * @param conversionTasks
         *        Information about the conversion tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTasks(Collection<ConversionTask> conversionTasks);

        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * 
         * @param conversionTasks
         *        Information about the conversion tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTasks(ConversionTask... conversionTasks);

        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ConversionTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ConversionTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ConversionTask.Builder#build()} is called immediately and
         * its result is passed to {@link #conversionTasks(List<ConversionTask>)}.
         * 
         * @param conversionTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ConversionTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversionTasks(java.util.Collection<ConversionTask>)
         */
        Builder conversionTasks(Consumer<ConversionTask.Builder>... conversionTasks);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ConversionTask> conversionTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksResponse model) {
            super(model);
            conversionTasks(model.conversionTasks);
        }

        public final List<ConversionTask.Builder> getConversionTasks() {
            List<ConversionTask.Builder> result = DescribeConversionTaskListCopier.copyToBuilder(this.conversionTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversionTasks(Collection<ConversionTask.BuilderImpl> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copyFromBuilder(conversionTasks);
        }

        @Override
        public final Builder conversionTasks(Collection<ConversionTask> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copy(conversionTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(ConversionTask... conversionTasks) {
            conversionTasks(Arrays.asList(conversionTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(Consumer<ConversionTask.Builder>... conversionTasks) {
            conversionTasks(Stream.of(conversionTasks).map(c -> ConversionTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeConversionTasksResponse build() {
            return new DescribeConversionTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
