/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageReferencesResponse;
import software.amazon.awssdk.services.ec2.model.ImageReference;

public class DescribeImageReferencesPublisher
implements SdkPublisher<DescribeImageReferencesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImageReferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImageReferencesPublisher(Ec2AsyncClient client, DescribeImageReferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImageReferencesPublisher(Ec2AsyncClient client, DescribeImageReferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImageReferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImageReferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageReference> imageReferences() {
        Function<DescribeImageReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageReferences() != null) {
                return response.imageReferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImageReferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImageReferencesResponseFetcher
    implements AsyncPageFetcher<DescribeImageReferencesResponse> {
        private DescribeImageReferencesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImageReferencesResponse> nextPage(DescribeImageReferencesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageReferencesPublisher.this.client.describeImageReferences(DescribeImageReferencesPublisher.this.firstRequest);
            }
            return DescribeImageReferencesPublisher.this.client.describeImageReferences((DescribeImageReferencesRequest)((Object)DescribeImageReferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

