/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteServerState {
    PENDING("pending"),
    AVAILABLE("available"),
    MODIFYING("modifying"),
    DELETING("deleting"),
    DELETED("deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteServerState> VALUE_MAP;
    private final String value;

    private RouteServerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteServerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteServerState> knownValues() {
        EnumSet<RouteServerState> knownValues = EnumSet.allOf(RouteServerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteServerState.class, RouteServerState::toString);
    }
}

