/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageReferencesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeImageReferencesRequest.Builder, DescribeImageReferencesRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImageIds")
            .getter(getter(DescribeImageReferencesRequest::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_RESOURCE_TYPES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllResourceTypes")
            .getter(getter(DescribeImageReferencesRequest::includeAllResourceTypes))
            .setter(setter(Builder::includeAllResourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllResourceTypes")
                    .unmarshallLocationName("IncludeAllResourceTypes").build()).build();

    private static final SdkField<List<ResourceTypeRequest>> RESOURCE_TYPES_FIELD = SdkField
            .<List<ResourceTypeRequest>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(DescribeImageReferencesRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("ResourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTypeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTypeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeImageReferencesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeImageReferencesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeImageReferencesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD,
            INCLUDE_ALL_RESOURCE_TYPES_FIELD, RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD, DRY_RUN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> imageIds;

    private final Boolean includeAllResourceTypes;

    private final List<ResourceTypeRequest> resourceTypes;

    private final String nextToken;

    private final Boolean dryRun;

    private final Integer maxResults;

    private DescribeImageReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.includeAllResourceTypes = builder.includeAllResourceTypes;
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the images to check for resource references.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageIds} method.
     * </p>
     * 
     * @return The IDs of the images to check for resource references.
     */
    public final List<String> imageIds() {
        return imageIds;
    }

    /**
     * <p>
     * Specifies whether to check all supported Amazon Web Services resource types for image references. When specified,
     * default values are applied for <code>ResourceTypeOptions</code>. For the default values, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-ami-references-works.html">How AMI reference checks
     * work</a> in the <i>Amazon EC2 User Guide</i>. If you also specify <code>ResourceTypes</code> with
     * <code>ResourceTypeOptions</code>, your specified values override the default values.
     * </p>
     * <p>
     * Supported resource types: <code>ec2:Instance</code> | <code>ec2:LaunchTemplate</code> |
     * <code>ssm:Parameter</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code>
     * </p>
     * <p>
     * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
     * </p>
     * 
     * @return Specifies whether to check all supported Amazon Web Services resource types for image references. When
     *         specified, default values are applied for <code>ResourceTypeOptions</code>. For the default values, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-ami-references-works.html">How AMI
     *         reference checks work</a> in the <i>Amazon EC2 User Guide</i>. If you also specify
     *         <code>ResourceTypes</code> with <code>ResourceTypeOptions</code>, your specified values override the
     *         default values.</p>
     *         <p>
     *         Supported resource types: <code>ec2:Instance</code> | <code>ec2:LaunchTemplate</code> |
     *         <code>ssm:Parameter</code> | <code>imagebuilder:ImageRecipe</code> |
     *         <code>imagebuilder:ContainerRecipe</code>
     *         </p>
     *         <p>
     *         Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
     */
    public final Boolean includeAllResourceTypes() {
        return includeAllResourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services resource types to check for image references.
     * </p>
     * <p>
     * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The Amazon Web Services resource types to check for image references.</p>
     *         <p>
     *         Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
     */
    public final List<ResourceTypeRequest> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeAllResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReferencesRequest)) {
            return false;
        }
        DescribeImageReferencesRequest other = (DescribeImageReferencesRequest) obj;
        return hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && Objects.equals(includeAllResourceTypes(), other.includeAllResourceTypes())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageReferencesRequest").add("ImageIds", hasImageIds() ? imageIds() : null)
                .add("IncludeAllResourceTypes", includeAllResourceTypes())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("NextToken", nextToken())
                .add("DryRun", dryRun()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "IncludeAllResourceTypes":
            return Optional.ofNullable(clazz.cast(includeAllResourceTypes()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageId", IMAGE_IDS_FIELD);
        map.put("IncludeAllResourceTypes", INCLUDE_ALL_RESOURCE_TYPES_FIELD);
        map.put("ResourceType", RESOURCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReferencesRequest, T> g) {
        return obj -> g.apply((DescribeImageReferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageReferencesRequest> {
        /**
         * <p>
         * The IDs of the images to check for resource references.
         * </p>
         * 
         * @param imageIds
         *        The IDs of the images to check for resource references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<String> imageIds);

        /**
         * <p>
         * The IDs of the images to check for resource references.
         * </p>
         * 
         * @param imageIds
         *        The IDs of the images to check for resource references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(String... imageIds);

        /**
         * <p>
         * Specifies whether to check all supported Amazon Web Services resource types for image references. When
         * specified, default values are applied for <code>ResourceTypeOptions</code>. For the default values, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-ami-references-works.html">How AMI reference
         * checks work</a> in the <i>Amazon EC2 User Guide</i>. If you also specify <code>ResourceTypes</code> with
         * <code>ResourceTypeOptions</code>, your specified values override the default values.
         * </p>
         * <p>
         * Supported resource types: <code>ec2:Instance</code> | <code>ec2:LaunchTemplate</code> |
         * <code>ssm:Parameter</code> | <code>imagebuilder:ImageRecipe</code> |
         * <code>imagebuilder:ContainerRecipe</code>
         * </p>
         * <p>
         * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * </p>
         * 
         * @param includeAllResourceTypes
         *        Specifies whether to check all supported Amazon Web Services resource types for image references. When
         *        specified, default values are applied for <code>ResourceTypeOptions</code>. For the default values,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-ami-references-works.html">How
         *        AMI reference checks work</a> in the <i>Amazon EC2 User Guide</i>. If you also specify
         *        <code>ResourceTypes</code> with <code>ResourceTypeOptions</code>, your specified values override the
         *        default values.</p>
         *        <p>
         *        Supported resource types: <code>ec2:Instance</code> | <code>ec2:LaunchTemplate</code> |
         *        <code>ssm:Parameter</code> | <code>imagebuilder:ImageRecipe</code> |
         *        <code>imagebuilder:ContainerRecipe</code>
         *        </p>
         *        <p>
         *        Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllResourceTypes(Boolean includeAllResourceTypes);

        /**
         * <p>
         * The Amazon Web Services resource types to check for image references.
         * </p>
         * <p>
         * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * </p>
         * 
         * @param resourceTypes
         *        The Amazon Web Services resource types to check for image references.</p>
         *        <p>
         *        Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceTypeRequest> resourceTypes);

        /**
         * <p>
         * The Amazon Web Services resource types to check for image references.
         * </p>
         * <p>
         * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * </p>
         * 
         * @param resourceTypes
         *        The Amazon Web Services resource types to check for image references.</p>
         *        <p>
         *        Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceTypeRequest... resourceTypes);

        /**
         * <p>
         * The Amazon Web Services resource types to check for image references.
         * </p>
         * <p>
         * Either <code>IncludeAllResourceTypes</code> or <code>ResourceTypes</code> must be specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ResourceTypeRequest.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ResourceTypeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ResourceTypeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceTypes(List<ResourceTypeRequest>)}.
         * 
         * @param resourceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ResourceTypeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTypes(java.util.Collection<ResourceTypeRequest>)
         */
        Builder resourceTypes(Consumer<ResourceTypeRequest.Builder>... resourceTypes);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeAllResourceTypes;

        private List<ResourceTypeRequest> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Boolean dryRun;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReferencesRequest model) {
            super(model);
            imageIds(model.imageIds);
            includeAllResourceTypes(model.includeAllResourceTypes);
            resourceTypes(model.resourceTypes);
            nextToken(model.nextToken);
            dryRun(model.dryRun);
            maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            if (imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return imageIds;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageReferencesImageIdStringListCopier.copy(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageReferencesImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final Boolean getIncludeAllResourceTypes() {
            return includeAllResourceTypes;
        }

        public final void setIncludeAllResourceTypes(Boolean includeAllResourceTypes) {
            this.includeAllResourceTypes = includeAllResourceTypes;
        }

        @Override
        public final Builder includeAllResourceTypes(Boolean includeAllResourceTypes) {
            this.includeAllResourceTypes = includeAllResourceTypes;
            return this;
        }

        public final List<ResourceTypeRequest.Builder> getResourceTypes() {
            List<ResourceTypeRequest.Builder> result = ResourceTypeRequestListCopier.copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<ResourceTypeRequest.BuilderImpl> resourceTypes) {
            this.resourceTypes = ResourceTypeRequestListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeRequest> resourceTypes) {
            this.resourceTypes = ResourceTypeRequestListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeRequest... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(Consumer<ResourceTypeRequest.Builder>... resourceTypes) {
            resourceTypes(Stream.of(resourceTypes).map(c -> ResourceTypeRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageReferencesRequest build() {
            return new DescribeImageReferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
