/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLaunchTemplateResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteLaunchTemplateResponse.Builder, DeleteLaunchTemplateResponse> {
    private static final SdkField<LaunchTemplate> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate")
            .getter(getter(DeleteLaunchTemplateResponse::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate")
                    .unmarshallLocationName("launchTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LaunchTemplate launchTemplate;

    private DeleteLaunchTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplate = builder.launchTemplate;
    }

    /**
     * <p>
     * Information about the launch template.
     * </p>
     * 
     * @return Information about the launch template.
     */
    public final LaunchTemplate launchTemplate() {
        return launchTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateResponse)) {
            return false;
        }
        DeleteLaunchTemplateResponse other = (DeleteLaunchTemplateResponse) obj;
        return Objects.equals(launchTemplate(), other.launchTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLaunchTemplateResponse").add("LaunchTemplate", launchTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLaunchTemplateResponse, T> g) {
        return obj -> g.apply((DeleteLaunchTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLaunchTemplateResponse> {
        /**
         * <p>
         * Information about the launch template.
         * </p>
         * 
         * @param launchTemplate
         *        Information about the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplate launchTemplate);

        /**
         * <p>
         * Information about the launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplate.Builder} avoiding the need
         * to create one manually via {@link LaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #launchTemplate(LaunchTemplate)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplate)
         */
        default Builder launchTemplate(Consumer<LaunchTemplate.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplate.builder().applyMutation(launchTemplate).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LaunchTemplate launchTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateResponse model) {
            super(model);
            launchTemplate(model.launchTemplate);
        }

        public final LaunchTemplate.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplate.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        @Override
        public DeleteLaunchTemplateResponse build() {
            return new DeleteLaunchTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
