/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlExclusions;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlMode;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEncryptionControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEncryptionControl> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(VpcEncryptionControl.getter(VpcEncryptionControl::vpcId)).setter(VpcEncryptionControl.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> VPC_ENCRYPTION_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEncryptionControlId").getter(VpcEncryptionControl.getter(VpcEncryptionControl::vpcEncryptionControlId)).setter(VpcEncryptionControl.setter(Builder::vpcEncryptionControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControlId").unmarshallLocationName("vpcEncryptionControlId").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(VpcEncryptionControl.getter(VpcEncryptionControl::modeAsString)).setter(VpcEncryptionControl.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").unmarshallLocationName("mode").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VpcEncryptionControl.getter(VpcEncryptionControl::stateAsString)).setter(VpcEncryptionControl.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(VpcEncryptionControl.getter(VpcEncryptionControl::stateMessage)).setter(VpcEncryptionControl.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<VpcEncryptionControlExclusions> RESOURCE_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceExclusions").getter(VpcEncryptionControl.getter(VpcEncryptionControl::resourceExclusions)).setter(VpcEncryptionControl.setter(Builder::resourceExclusions)).constructor(VpcEncryptionControlExclusions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceExclusions").unmarshallLocationName("resourceExclusions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VpcEncryptionControl.getter(VpcEncryptionControl::tags)).setter(VpcEncryptionControl.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD, VPC_ENCRYPTION_CONTROL_ID_FIELD, MODE_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, RESOURCE_EXCLUSIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcEncryptionControl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcId;
    private final String vpcEncryptionControlId;
    private final String mode;
    private final String state;
    private final String stateMessage;
    private final VpcEncryptionControlExclusions resourceExclusions;
    private final List<Tag> tags;

    private VpcEncryptionControl(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.vpcEncryptionControlId = builder.vpcEncryptionControlId;
        this.mode = builder.mode;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.resourceExclusions = builder.resourceExclusions;
        this.tags = builder.tags;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String vpcEncryptionControlId() {
        return this.vpcEncryptionControlId;
    }

    public final VpcEncryptionControlMode mode() {
        return VpcEncryptionControlMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final VpcEncryptionControlState state() {
        return VpcEncryptionControlState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final VpcEncryptionControlExclusions resourceExclusions() {
        return this.resourceExclusions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEncryptionControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceExclusions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEncryptionControl)) {
            return false;
        }
        VpcEncryptionControl other = (VpcEncryptionControl)obj;
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcEncryptionControlId(), other.vpcEncryptionControlId()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.resourceExclusions(), other.resourceExclusions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEncryptionControl").add("VpcId", (Object)this.vpcId()).add("VpcEncryptionControlId", (Object)this.vpcEncryptionControlId()).add("Mode", (Object)this.modeAsString()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("ResourceExclusions", (Object)this.resourceExclusions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcEncryptionControlId": {
                return Optional.ofNullable(clazz.cast(this.vpcEncryptionControlId()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "ResourceExclusions": {
                return Optional.ofNullable(clazz.cast(this.resourceExclusions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcEncryptionControlId", VPC_ENCRYPTION_CONTROL_ID_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("ResourceExclusions", RESOURCE_EXCLUSIONS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEncryptionControl, T> g) {
        return obj -> g.apply((VpcEncryptionControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcId;
        private String vpcEncryptionControlId;
        private String mode;
        private String state;
        private String stateMessage;
        private VpcEncryptionControlExclusions resourceExclusions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEncryptionControl model) {
            this.vpcId(model.vpcId);
            this.vpcEncryptionControlId(model.vpcEncryptionControlId);
            this.mode(model.mode);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.resourceExclusions(model.resourceExclusions);
            this.tags(model.tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcEncryptionControlId() {
            return this.vpcEncryptionControlId;
        }

        public final void setVpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
        }

        @Override
        public final Builder vpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(VpcEncryptionControlMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcEncryptionControlState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final VpcEncryptionControlExclusions.Builder getResourceExclusions() {
            return this.resourceExclusions != null ? this.resourceExclusions.toBuilder() : null;
        }

        public final void setResourceExclusions(VpcEncryptionControlExclusions.BuilderImpl resourceExclusions) {
            this.resourceExclusions = resourceExclusions != null ? resourceExclusions.build() : null;
        }

        @Override
        public final Builder resourceExclusions(VpcEncryptionControlExclusions resourceExclusions) {
            this.resourceExclusions = resourceExclusions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VpcEncryptionControl build() {
            return new VpcEncryptionControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEncryptionControl> {
        public Builder vpcId(String var1);

        public Builder vpcEncryptionControlId(String var1);

        public Builder mode(String var1);

        public Builder mode(VpcEncryptionControlMode var1);

        public Builder state(String var1);

        public Builder state(VpcEncryptionControlState var1);

        public Builder stateMessage(String var1);

        public Builder resourceExclusions(VpcEncryptionControlExclusions var1);

        default public Builder resourceExclusions(Consumer<VpcEncryptionControlExclusions.Builder> resourceExclusions) {
            return this.resourceExclusions((VpcEncryptionControlExclusions)((VpcEncryptionControlExclusions.Builder)VpcEncryptionControlExclusions.builder().applyMutation(resourceExclusions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

