/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DescribeImageReferencesImageIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ResourceTypeRequest;
import software.amazon.awssdk.services.ec2.model.ResourceTypeRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageReferencesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeImageReferencesRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageIds").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::imageIds)).setter(DescribeImageReferencesRequest.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllResourceTypes").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::includeAllResourceTypes)).setter(DescribeImageReferencesRequest.setter(Builder::includeAllResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllResourceTypes").unmarshallLocationName("IncludeAllResourceTypes").build()}).build();
    private static final SdkField<List<ResourceTypeRequest>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::resourceTypes)).setter(DescribeImageReferencesRequest.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTypeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::nextToken)).setter(DescribeImageReferencesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::dryRun)).setter(DescribeImageReferencesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeImageReferencesRequest.getter(DescribeImageReferencesRequest::maxResults)).setter(DescribeImageReferencesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD, INCLUDE_ALL_RESOURCE_TYPES_FIELD, RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD, DRY_RUN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageReferencesRequest.memberNameToFieldInitializer();
    private final List<String> imageIds;
    private final Boolean includeAllResourceTypes;
    private final List<ResourceTypeRequest> resourceTypes;
    private final String nextToken;
    private final Boolean dryRun;
    private final Integer maxResults;

    private DescribeImageReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.includeAllResourceTypes = builder.includeAllResourceTypes;
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public final List<String> imageIds() {
        return this.imageIds;
    }

    public final Boolean includeAllResourceTypes() {
        return this.includeAllResourceTypes;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<ResourceTypeRequest> resourceTypes() {
        return this.resourceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageIds() ? this.imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReferencesRequest)) {
            return false;
        }
        DescribeImageReferencesRequest other = (DescribeImageReferencesRequest)((Object)obj);
        return this.hasImageIds() == other.hasImageIds() && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.includeAllResourceTypes(), other.includeAllResourceTypes()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageReferencesRequest").add("ImageIds", this.hasImageIds() ? this.imageIds() : null).add("IncludeAllResourceTypes", (Object)this.includeAllResourceTypes()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("NextToken", (Object)this.nextToken()).add("DryRun", (Object)this.dryRun()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "IncludeAllResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.includeAllResourceTypes()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_IDS_FIELD);
        map.put("IncludeAllResourceTypes", INCLUDE_ALL_RESOURCE_TYPES_FIELD);
        map.put("ResourceType", RESOURCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReferencesRequest, T> g) {
        return obj -> g.apply((DescribeImageReferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeAllResourceTypes;
        private List<ResourceTypeRequest> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Boolean dryRun;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReferencesRequest model) {
            super(model);
            this.imageIds(model.imageIds);
            this.includeAllResourceTypes(model.includeAllResourceTypes);
            this.resourceTypes(model.resourceTypes);
            this.nextToken(model.nextToken);
            this.dryRun(model.dryRun);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            if (this.imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageIds;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageReferencesImageIdStringListCopier.copy(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = DescribeImageReferencesImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final Boolean getIncludeAllResourceTypes() {
            return this.includeAllResourceTypes;
        }

        public final void setIncludeAllResourceTypes(Boolean includeAllResourceTypes) {
            this.includeAllResourceTypes = includeAllResourceTypes;
        }

        @Override
        public final Builder includeAllResourceTypes(Boolean includeAllResourceTypes) {
            this.includeAllResourceTypes = includeAllResourceTypes;
            return this;
        }

        public final List<ResourceTypeRequest.Builder> getResourceTypes() {
            List<ResourceTypeRequest.Builder> result = ResourceTypeRequestListCopier.copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<ResourceTypeRequest.BuilderImpl> resourceTypes) {
            this.resourceTypes = ResourceTypeRequestListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeRequest> resourceTypes) {
            this.resourceTypes = ResourceTypeRequestListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeRequest ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(Consumer<ResourceTypeRequest.Builder> ... resourceTypes) {
            this.resourceTypes(Stream.of(resourceTypes).map(c -> (ResourceTypeRequest)((ResourceTypeRequest.Builder)ResourceTypeRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageReferencesRequest build() {
            return new DescribeImageReferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageReferencesRequest> {
        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder includeAllResourceTypes(Boolean var1);

        public Builder resourceTypes(Collection<ResourceTypeRequest> var1);

        public Builder resourceTypes(ResourceTypeRequest ... var1);

        public Builder resourceTypes(Consumer<ResourceTypeRequest.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

