/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TrafficDirection;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleField;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleFieldListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRangeRequest;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTrafficMirrorFilterRuleRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTrafficMirrorFilterRuleRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterRuleId").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::trafficMirrorFilterRuleId)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::trafficMirrorFilterRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleId").unmarshallLocationName("TrafficMirrorFilterRuleId").build()}).build();
    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficDirection").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::trafficDirectionAsString)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::trafficDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection").unmarshallLocationName("TrafficDirection").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleNumber").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::ruleNumber)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("RuleNumber").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::ruleActionAsString)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("RuleAction").build()}).build();
    private static final SdkField<TrafficMirrorPortRangeRequest> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationPortRange").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::destinationPortRange)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::destinationPortRange)).constructor(TrafficMirrorPortRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("DestinationPortRange").build()}).build();
    private static final SdkField<TrafficMirrorPortRangeRequest> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourcePortRange").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::sourcePortRange)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::sourcePortRange)).constructor(TrafficMirrorPortRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("SourcePortRange").build()}).build();
    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Protocol").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::protocol)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::destinationCidrBlock)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCidrBlock").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::sourceCidrBlock)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::sourceCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock").unmarshallLocationName("SourceCidrBlock").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::description)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<String>> REMOVE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveFields").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::removeFieldsAsStrings)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::removeFieldsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveField").unmarshallLocationName("RemoveField").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyTrafficMirrorFilterRuleRequest.getter(ModifyTrafficMirrorFilterRuleRequest::dryRun)).setter(ModifyTrafficMirrorFilterRuleRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD, RULE_ACTION_FIELD, DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD, PROTOCOL_FIELD, DESTINATION_CIDR_BLOCK_FIELD, SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD, REMOVE_FIELDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyTrafficMirrorFilterRuleRequest.memberNameToFieldInitializer();
    private final String trafficMirrorFilterRuleId;
    private final String trafficDirection;
    private final Integer ruleNumber;
    private final String ruleAction;
    private final TrafficMirrorPortRangeRequest destinationPortRange;
    private final TrafficMirrorPortRangeRequest sourcePortRange;
    private final Integer protocol;
    private final String destinationCidrBlock;
    private final String sourceCidrBlock;
    private final String description;
    private final List<String> removeFields;
    private final Boolean dryRun;

    private ModifyTrafficMirrorFilterRuleRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterRuleId = builder.trafficMirrorFilterRuleId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.protocol = builder.protocol;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
        this.removeFields = builder.removeFields;
        this.dryRun = builder.dryRun;
    }

    public final String trafficMirrorFilterRuleId() {
        return this.trafficMirrorFilterRuleId;
    }

    public final TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(this.trafficDirection);
    }

    public final String trafficDirectionAsString() {
        return this.trafficDirection;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    public final TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final TrafficMirrorPortRangeRequest destinationPortRange() {
        return this.destinationPortRange;
    }

    public final TrafficMirrorPortRangeRequest sourcePortRange() {
        return this.sourcePortRange;
    }

    public final Integer protocol() {
        return this.protocol;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    public final String description() {
        return this.description;
    }

    public final List<TrafficMirrorFilterRuleField> removeFields() {
        return TrafficMirrorFilterRuleFieldListCopier.copyStringToEnum(this.removeFields);
    }

    public final boolean hasRemoveFields() {
        return this.removeFields != null && !(this.removeFields instanceof SdkAutoConstructList);
    }

    public final List<String> removeFieldsAsStrings() {
        return this.removeFields;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveFields() ? this.removeFieldsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorFilterRuleRequest)) {
            return false;
        }
        ModifyTrafficMirrorFilterRuleRequest other = (ModifyTrafficMirrorFilterRuleRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorFilterRuleId(), other.trafficMirrorFilterRuleId()) && Objects.equals(this.trafficDirectionAsString(), other.trafficDirectionAsString()) && Objects.equals(this.ruleNumber(), other.ruleNumber()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.sourceCidrBlock(), other.sourceCidrBlock()) && Objects.equals(this.description(), other.description()) && this.hasRemoveFields() == other.hasRemoveFields() && Objects.equals(this.removeFieldsAsStrings(), other.removeFieldsAsStrings()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTrafficMirrorFilterRuleRequest").add("TrafficMirrorFilterRuleId", (Object)this.trafficMirrorFilterRuleId()).add("TrafficDirection", (Object)this.trafficDirectionAsString()).add("RuleNumber", (Object)this.ruleNumber()).add("RuleAction", (Object)this.ruleActionAsString()).add("DestinationPortRange", (Object)this.destinationPortRange()).add("SourcePortRange", (Object)this.sourcePortRange()).add("Protocol", (Object)this.protocol()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("SourceCidrBlock", (Object)this.sourceCidrBlock()).add("Description", (Object)this.description()).add("RemoveFields", this.hasRemoveFields() ? this.removeFieldsAsStrings() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterRuleId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterRuleId()));
            }
            case "TrafficDirection": {
                return Optional.ofNullable(clazz.cast(this.trafficDirectionAsString()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "SourceCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.sourceCidrBlock()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemoveFields": {
                return Optional.ofNullable(clazz.cast(this.removeFieldsAsStrings()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrafficMirrorFilterRuleId", TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD);
        map.put("TrafficDirection", TRAFFIC_DIRECTION_FIELD);
        map.put("RuleNumber", RULE_NUMBER_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RemoveField", REMOVE_FIELDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorFilterRuleRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorFilterRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trafficMirrorFilterRuleId;
        private String trafficDirection;
        private Integer ruleNumber;
        private String ruleAction;
        private TrafficMirrorPortRangeRequest destinationPortRange;
        private TrafficMirrorPortRangeRequest sourcePortRange;
        private Integer protocol;
        private String destinationCidrBlock;
        private String sourceCidrBlock;
        private String description;
        private List<String> removeFields = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorFilterRuleRequest model) {
            super(model);
            this.trafficMirrorFilterRuleId(model.trafficMirrorFilterRuleId);
            this.trafficDirection(model.trafficDirection);
            this.ruleNumber(model.ruleNumber);
            this.ruleAction(model.ruleAction);
            this.destinationPortRange(model.destinationPortRange);
            this.sourcePortRange(model.sourcePortRange);
            this.protocol(model.protocol);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.sourceCidrBlock(model.sourceCidrBlock);
            this.description(model.description);
            this.removeFieldsWithStrings(model.removeFields);
            this.dryRun(model.dryRun);
        }

        public final String getTrafficMirrorFilterRuleId() {
            return this.trafficMirrorFilterRuleId;
        }

        public final void setTrafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
        }

        @Override
        public final Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
            return this;
        }

        public final String getTrafficDirection() {
            return this.trafficDirection;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        @Override
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getDestinationPortRange() {
            return this.destinationPortRange != null ? this.destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRangeRequest.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        public final Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getSourcePortRange() {
            return this.sourcePortRange != null ? this.sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(TrafficMirrorPortRangeRequest.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        public final Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final Integer getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRemoveFields() {
            if (this.removeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeFields;
        }

        public final void setRemoveFields(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorFilterRuleFieldListCopier.copy(removeFields);
        }

        @Override
        public final Builder removeFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorFilterRuleFieldListCopier.copy(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFieldsWithStrings(String ... removeFields) {
            this.removeFieldsWithStrings(Arrays.asList(removeFields));
            return this;
        }

        @Override
        public final Builder removeFields(Collection<TrafficMirrorFilterRuleField> removeFields) {
            this.removeFields = TrafficMirrorFilterRuleFieldListCopier.copyEnumToString(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFields(TrafficMirrorFilterRuleField ... removeFields) {
            this.removeFields(Arrays.asList(removeFields));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorFilterRuleRequest build() {
            return new ModifyTrafficMirrorFilterRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTrafficMirrorFilterRuleRequest> {
        public Builder trafficMirrorFilterRuleId(String var1);

        public Builder trafficDirection(String var1);

        public Builder trafficDirection(TrafficDirection var1);

        public Builder ruleNumber(Integer var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(TrafficMirrorRuleAction var1);

        public Builder destinationPortRange(TrafficMirrorPortRangeRequest var1);

        default public Builder destinationPortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> destinationPortRange) {
            return this.destinationPortRange((TrafficMirrorPortRangeRequest)((TrafficMirrorPortRangeRequest.Builder)TrafficMirrorPortRangeRequest.builder().applyMutation(destinationPortRange)).build());
        }

        public Builder sourcePortRange(TrafficMirrorPortRangeRequest var1);

        default public Builder sourcePortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> sourcePortRange) {
            return this.sourcePortRange((TrafficMirrorPortRangeRequest)((TrafficMirrorPortRangeRequest.Builder)TrafficMirrorPortRangeRequest.builder().applyMutation(sourcePortRange)).build());
        }

        public Builder protocol(Integer var1);

        public Builder destinationCidrBlock(String var1);

        public Builder sourceCidrBlock(String var1);

        public Builder description(String var1);

        public Builder removeFieldsWithStrings(Collection<String> var1);

        public Builder removeFieldsWithStrings(String ... var1);

        public Builder removeFields(Collection<TrafficMirrorFilterRuleField> var1);

        public Builder removeFields(TrafficMirrorFilterRuleField ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

