/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityBlockOfferingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeCapacityBlockOfferingsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::dryRun)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::instanceType)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::instanceCount)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<Instant> START_DATE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDateRange").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::startDateRange)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::startDateRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateRange").unmarshallLocationName("StartDateRange").build()}).build();
    private static final SdkField<Instant> END_DATE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDateRange").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::endDateRange)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::endDateRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateRange").unmarshallLocationName("EndDateRange").build()}).build();
    private static final SdkField<Integer> CAPACITY_DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CapacityDurationHours").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::capacityDurationHours)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::capacityDurationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityDurationHours").unmarshallLocationName("CapacityDurationHours").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::nextToken)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeCapacityBlockOfferingsRequest.getter(DescribeCapacityBlockOfferingsRequest::maxResults)).setter(DescribeCapacityBlockOfferingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, START_DATE_RANGE_FIELD, END_DATE_RANGE_FIELD, CAPACITY_DURATION_HOURS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityBlockOfferingsRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String instanceType;
    private final Integer instanceCount;
    private final Instant startDateRange;
    private final Instant endDateRange;
    private final Integer capacityDurationHours;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeCapacityBlockOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.startDateRange = builder.startDateRange;
        this.endDateRange = builder.endDateRange;
        this.capacityDurationHours = builder.capacityDurationHours;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Instant startDateRange() {
        return this.startDateRange;
    }

    public final Instant endDateRange() {
        return this.endDateRange;
    }

    public final Integer capacityDurationHours() {
        return this.capacityDurationHours;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockOfferingsRequest)) {
            return false;
        }
        DescribeCapacityBlockOfferingsRequest other = (DescribeCapacityBlockOfferingsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.startDateRange(), other.startDateRange()) && Objects.equals(this.endDateRange(), other.endDateRange()) && Objects.equals(this.capacityDurationHours(), other.capacityDurationHours()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityBlockOfferingsRequest").add("DryRun", (Object)this.dryRun()).add("InstanceType", (Object)this.instanceType()).add("InstanceCount", (Object)this.instanceCount()).add("StartDateRange", (Object)this.startDateRange()).add("EndDateRange", (Object)this.endDateRange()).add("CapacityDurationHours", (Object)this.capacityDurationHours()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "StartDateRange": {
                return Optional.ofNullable(clazz.cast(this.startDateRange()));
            }
            case "EndDateRange": {
                return Optional.ofNullable(clazz.cast(this.endDateRange()));
            }
            case "CapacityDurationHours": {
                return Optional.ofNullable(clazz.cast(this.capacityDurationHours()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartDateRange", START_DATE_RANGE_FIELD);
        map.put("EndDateRange", END_DATE_RANGE_FIELD);
        map.put("CapacityDurationHours", CAPACITY_DURATION_HOURS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeCapacityBlockOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String instanceType;
        private Integer instanceCount;
        private Instant startDateRange;
        private Instant endDateRange;
        private Integer capacityDurationHours;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockOfferingsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.startDateRange(model.startDateRange);
            this.endDateRange(model.endDateRange);
            this.capacityDurationHours(model.capacityDurationHours);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartDateRange() {
            return this.startDateRange;
        }

        public final void setStartDateRange(Instant startDateRange) {
            this.startDateRange = startDateRange;
        }

        @Override
        public final Builder startDateRange(Instant startDateRange) {
            this.startDateRange = startDateRange;
            return this;
        }

        public final Instant getEndDateRange() {
            return this.endDateRange;
        }

        public final void setEndDateRange(Instant endDateRange) {
            this.endDateRange = endDateRange;
        }

        @Override
        public final Builder endDateRange(Instant endDateRange) {
            this.endDateRange = endDateRange;
            return this;
        }

        public final Integer getCapacityDurationHours() {
            return this.capacityDurationHours;
        }

        public final void setCapacityDurationHours(Integer capacityDurationHours) {
            this.capacityDurationHours = capacityDurationHours;
        }

        @Override
        public final Builder capacityDurationHours(Integer capacityDurationHours) {
            this.capacityDurationHours = capacityDurationHours;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityBlockOfferingsRequest build() {
            return new DescribeCapacityBlockOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityBlockOfferingsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder startDateRange(Instant var1);

        public Builder endDateRange(Instant var1);

        public Builder capacityDurationHours(Integer var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

