/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrefixList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrefixList> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cidrs").getter(PrefixList.getter(PrefixList::cidrs)).setter(PrefixList.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrSet").unmarshallLocationName("cidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(PrefixList.getter(PrefixList::prefixListId)).setter(PrefixList.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListName").getter(PrefixList.getter(PrefixList::prefixListName)).setter(PrefixList.setter(Builder::prefixListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName").unmarshallLocationName("prefixListName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrefixList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cidrs;
    private final String prefixListId;
    private final String prefixListName;

    private PrefixList(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
        this.prefixListId = builder.prefixListId;
        this.prefixListName = builder.prefixListName;
    }

    public final boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public final List<String> cidrs() {
        return this.cidrs;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String prefixListName() {
        return this.prefixListName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixList)) {
            return false;
        }
        PrefixList other = (PrefixList)obj;
        return this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.prefixListName(), other.prefixListName());
    }

    public final String toString() {
        return ToString.builder((String)"PrefixList").add("Cidrs", this.hasCidrs() ? this.cidrs() : null).add("PrefixListId", (Object)this.prefixListId()).add("PrefixListName", (Object)this.prefixListName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "PrefixListName": {
                return Optional.ofNullable(clazz.cast(this.prefixListName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CidrSet", CIDRS_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PrefixListName", PREFIX_LIST_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefixList, T> g) {
        return obj -> g.apply((PrefixList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private String prefixListId;
        private String prefixListName;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixList model) {
            this.cidrs(model.cidrs);
            this.prefixListId(model.prefixListId);
            this.prefixListName(model.prefixListName);
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListName() {
            return this.prefixListName;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public PrefixList build() {
            return new PrefixList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrefixList> {
        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder prefixListId(String var1);

        public Builder prefixListName(String var1);
    }
}

