/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVpnConnectionDeviceSampleConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetVpnConnectionDeviceSampleConfigurationRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(GetVpnConnectionDeviceSampleConfigurationRequest.getter(GetVpnConnectionDeviceSampleConfigurationRequest::vpnConnectionId)).setter(GetVpnConnectionDeviceSampleConfigurationRequest.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build()}).build();
    private static final SdkField<String> VPN_CONNECTION_DEVICE_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionDeviceTypeId").getter(GetVpnConnectionDeviceSampleConfigurationRequest.getter(GetVpnConnectionDeviceSampleConfigurationRequest::vpnConnectionDeviceTypeId)).setter(GetVpnConnectionDeviceSampleConfigurationRequest.setter(Builder::vpnConnectionDeviceTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionDeviceTypeId").unmarshallLocationName("VpnConnectionDeviceTypeId").build()}).build();
    private static final SdkField<String> INTERNET_KEY_EXCHANGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetKeyExchangeVersion").getter(GetVpnConnectionDeviceSampleConfigurationRequest.getter(GetVpnConnectionDeviceSampleConfigurationRequest::internetKeyExchangeVersion)).setter(GetVpnConnectionDeviceSampleConfigurationRequest.setter(Builder::internetKeyExchangeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetKeyExchangeVersion").unmarshallLocationName("InternetKeyExchangeVersion").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetVpnConnectionDeviceSampleConfigurationRequest.getter(GetVpnConnectionDeviceSampleConfigurationRequest::dryRun)).setter(GetVpnConnectionDeviceSampleConfigurationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, VPN_CONNECTION_DEVICE_TYPE_ID_FIELD, INTERNET_KEY_EXCHANGE_VERSION_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetVpnConnectionDeviceSampleConfigurationRequest.memberNameToFieldInitializer();
    private final String vpnConnectionId;
    private final String vpnConnectionDeviceTypeId;
    private final String internetKeyExchangeVersion;
    private final Boolean dryRun;

    private GetVpnConnectionDeviceSampleConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnConnectionDeviceTypeId = builder.vpnConnectionDeviceTypeId;
        this.internetKeyExchangeVersion = builder.internetKeyExchangeVersion;
        this.dryRun = builder.dryRun;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final String vpnConnectionDeviceTypeId() {
        return this.vpnConnectionDeviceTypeId;
    }

    public final String internetKeyExchangeVersion() {
        return this.internetKeyExchangeVersion;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionDeviceTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetKeyExchangeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpnConnectionDeviceSampleConfigurationRequest)) {
            return false;
        }
        GetVpnConnectionDeviceSampleConfigurationRequest other = (GetVpnConnectionDeviceSampleConfigurationRequest)((Object)obj);
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.vpnConnectionDeviceTypeId(), other.vpnConnectionDeviceTypeId()) && Objects.equals(this.internetKeyExchangeVersion(), other.internetKeyExchangeVersion()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"GetVpnConnectionDeviceSampleConfigurationRequest").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("VpnConnectionDeviceTypeId", (Object)this.vpnConnectionDeviceTypeId()).add("InternetKeyExchangeVersion", (Object)this.internetKeyExchangeVersion()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "VpnConnectionDeviceTypeId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionDeviceTypeId()));
            }
            case "InternetKeyExchangeVersion": {
                return Optional.ofNullable(clazz.cast(this.internetKeyExchangeVersion()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
        map.put("VpnConnectionDeviceTypeId", VPN_CONNECTION_DEVICE_TYPE_ID_FIELD);
        map.put("InternetKeyExchangeVersion", INTERNET_KEY_EXCHANGE_VERSION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVpnConnectionDeviceSampleConfigurationRequest, T> g) {
        return obj -> g.apply((GetVpnConnectionDeviceSampleConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String vpnConnectionDeviceTypeId;
        private String internetKeyExchangeVersion;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpnConnectionDeviceSampleConfigurationRequest model) {
            super(model);
            this.vpnConnectionId(model.vpnConnectionId);
            this.vpnConnectionDeviceTypeId(model.vpnConnectionDeviceTypeId);
            this.internetKeyExchangeVersion(model.internetKeyExchangeVersion);
            this.dryRun(model.dryRun);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getVpnConnectionDeviceTypeId() {
            return this.vpnConnectionDeviceTypeId;
        }

        public final void setVpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
        }

        @Override
        public final Builder vpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
            return this;
        }

        public final String getInternetKeyExchangeVersion() {
            return this.internetKeyExchangeVersion;
        }

        public final void setInternetKeyExchangeVersion(String internetKeyExchangeVersion) {
            this.internetKeyExchangeVersion = internetKeyExchangeVersion;
        }

        @Override
        public final Builder internetKeyExchangeVersion(String internetKeyExchangeVersion) {
            this.internetKeyExchangeVersion = internetKeyExchangeVersion;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVpnConnectionDeviceSampleConfigurationRequest build() {
            return new GetVpnConnectionDeviceSampleConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVpnConnectionDeviceSampleConfigurationRequest> {
        public Builder vpnConnectionId(String var1);

        public Builder vpnConnectionDeviceTypeId(String var1);

        public Builder internetKeyExchangeVersion(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

