/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask;

public class DescribeReplaceRootVolumeTasksPublisher
implements SdkPublisher<DescribeReplaceRootVolumeTasksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeReplaceRootVolumeTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplaceRootVolumeTasksPublisher(Ec2AsyncClient client, DescribeReplaceRootVolumeTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplaceRootVolumeTasksPublisher(Ec2AsyncClient client, DescribeReplaceRootVolumeTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplaceRootVolumeTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplaceRootVolumeTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplaceRootVolumeTask> replaceRootVolumeTasks() {
        Function<DescribeReplaceRootVolumeTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.replaceRootVolumeTasks() != null) {
                return response.replaceRootVolumeTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReplaceRootVolumeTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReplaceRootVolumeTasksResponseFetcher
    implements AsyncPageFetcher<DescribeReplaceRootVolumeTasksResponse> {
        private DescribeReplaceRootVolumeTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplaceRootVolumeTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReplaceRootVolumeTasksResponse> nextPage(DescribeReplaceRootVolumeTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplaceRootVolumeTasksPublisher.this.client.describeReplaceRootVolumeTasks(DescribeReplaceRootVolumeTasksPublisher.this.firstRequest);
            }
            return DescribeReplaceRootVolumeTasksPublisher.this.client.describeReplaceRootVolumeTasks((DescribeReplaceRootVolumeTasksRequest)((Object)DescribeReplaceRootVolumeTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

