/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.NetworkNodesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTopology
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTopology> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceTopology.getter(InstanceTopology::instanceId)).setter(InstanceTopology.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTopology.getter(InstanceTopology::instanceType)).setter(InstanceTopology.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(InstanceTopology.getter(InstanceTopology::groupName)).setter(InstanceTopology.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<List<String>> NETWORK_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkNodes").getter(InstanceTopology.getter(InstanceTopology::networkNodes)).setter(InstanceTopology.setter(Builder::networkNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkNodeSet").unmarshallLocationName("networkNodeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(InstanceTopology.getter(InstanceTopology::availabilityZone)).setter(InstanceTopology.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneId").getter(InstanceTopology.getter(InstanceTopology::zoneId)).setter(InstanceTopology.setter(Builder::zoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId").unmarshallLocationName("zoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, GROUP_NAME_FIELD, NETWORK_NODES_FIELD, AVAILABILITY_ZONE_FIELD, ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceTopology.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String instanceType;
    private final String groupName;
    private final List<String> networkNodes;
    private final String availabilityZone;
    private final String zoneId;

    private InstanceTopology(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.groupName = builder.groupName;
        this.networkNodes = builder.networkNodes;
        this.availabilityZone = builder.availabilityZone;
        this.zoneId = builder.zoneId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasNetworkNodes() {
        return this.networkNodes != null && !(this.networkNodes instanceof SdkAutoConstructList);
    }

    public final List<String> networkNodes() {
        return this.networkNodes;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String zoneId() {
        return this.zoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkNodes() ? this.networkNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTopology)) {
            return false;
        }
        InstanceTopology other = (InstanceTopology)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.groupName(), other.groupName()) && this.hasNetworkNodes() == other.hasNetworkNodes() && Objects.equals(this.networkNodes(), other.networkNodes()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.zoneId(), other.zoneId());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTopology").add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("GroupName", (Object)this.groupName()).add("NetworkNodes", this.hasNetworkNodes() ? this.networkNodes() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("ZoneId", (Object)this.zoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "NetworkNodes": {
                return Optional.ofNullable(clazz.cast(this.networkNodes()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ZoneId": {
                return Optional.ofNullable(clazz.cast(this.zoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("NetworkNodeSet", NETWORK_NODES_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("ZoneId", ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceTopology, T> g) {
        return obj -> g.apply((InstanceTopology)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceType;
        private String groupName;
        private List<String> networkNodes = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String zoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTopology model) {
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.groupName(model.groupName);
            this.networkNodes(model.networkNodes);
            this.availabilityZone(model.availabilityZone);
            this.zoneId(model.zoneId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Collection<String> getNetworkNodes() {
            if (this.networkNodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkNodes;
        }

        public final void setNetworkNodes(Collection<String> networkNodes) {
            this.networkNodes = NetworkNodesListCopier.copy(networkNodes);
        }

        @Override
        public final Builder networkNodes(Collection<String> networkNodes) {
            this.networkNodes = NetworkNodesListCopier.copy(networkNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkNodes(String ... networkNodes) {
            this.networkNodes(Arrays.asList(networkNodes));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getZoneId() {
            return this.zoneId;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public InstanceTopology build() {
            return new InstanceTopology(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTopology> {
        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder groupName(String var1);

        public Builder networkNodes(Collection<String> var1);

        public Builder networkNodes(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder zoneId(String var1);
    }
}

