/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceConfigurationState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalGatewayVirtualInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalGatewayVirtualInterface> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceId)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayVirtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceId").unmarshallLocationName("localGatewayVirtualInterfaceId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayId)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("localGatewayId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceGroupId)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceArn").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceArn)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayVirtualInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceArn").unmarshallLocationName("localGatewayVirtualInterfaceArn").build()}).build();
    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostLagId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::outpostLagId)).setter(LocalGatewayVirtualInterface.setter(Builder::outpostLagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId").unmarshallLocationName("outpostLagId").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Vlan").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::vlan)).setter(LocalGatewayVirtualInterface.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan").unmarshallLocationName("vlan").build()}).build();
    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalAddress").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localAddress)).setter(LocalGatewayVirtualInterface.setter(Builder::localAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress").unmarshallLocationName("localAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::peerAddress)).setter(LocalGatewayVirtualInterface.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LocalBgpAsn").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localBgpAsn)).setter(LocalGatewayVirtualInterface.setter(Builder::localBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn").unmarshallLocationName("localBgpAsn").build()}).build();
    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeerBgpAsn").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::peerBgpAsn)).setter(LocalGatewayVirtualInterface.setter(Builder::peerBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn").unmarshallLocationName("peerBgpAsn").build()}).build();
    private static final SdkField<Long> PEER_BGP_ASN_EXTENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PeerBgpAsnExtended").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::peerBgpAsnExtended)).setter(LocalGatewayVirtualInterface.setter(Builder::peerBgpAsnExtended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsnExtended").unmarshallLocationName("peerBgpAsnExtended").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::ownerId)).setter(LocalGatewayVirtualInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::tags)).setter(LocalGatewayVirtualInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationState").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::configurationStateAsString)).setter(LocalGatewayVirtualInterface.setter(Builder::configurationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState").unmarshallLocationName("configurationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD, OUTPOST_LAG_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD, LOCAL_BGP_ASN_FIELD, PEER_BGP_ASN_FIELD, PEER_BGP_ASN_EXTENDED_FIELD, OWNER_ID_FIELD, TAGS_FIELD, CONFIGURATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LocalGatewayVirtualInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String localGatewayVirtualInterfaceId;
    private final String localGatewayId;
    private final String localGatewayVirtualInterfaceGroupId;
    private final String localGatewayVirtualInterfaceArn;
    private final String outpostLagId;
    private final Integer vlan;
    private final String localAddress;
    private final String peerAddress;
    private final Integer localBgpAsn;
    private final Integer peerBgpAsn;
    private final Long peerBgpAsnExtended;
    private final String ownerId;
    private final List<Tag> tags;
    private final String configurationState;

    private LocalGatewayVirtualInterface(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceId = builder.localGatewayVirtualInterfaceId;
        this.localGatewayId = builder.localGatewayId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayVirtualInterfaceArn = builder.localGatewayVirtualInterfaceArn;
        this.outpostLagId = builder.outpostLagId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.localBgpAsn = builder.localBgpAsn;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.peerBgpAsnExtended = builder.peerBgpAsnExtended;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.configurationState = builder.configurationState;
    }

    public final String localGatewayVirtualInterfaceId() {
        return this.localGatewayVirtualInterfaceId;
    }

    public final String localGatewayId() {
        return this.localGatewayId;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    public final String localGatewayVirtualInterfaceArn() {
        return this.localGatewayVirtualInterfaceArn;
    }

    public final String outpostLagId() {
        return this.outpostLagId;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final String localAddress() {
        return this.localAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final Integer localBgpAsn() {
        return this.localBgpAsn;
    }

    public final Integer peerBgpAsn() {
        return this.peerBgpAsn;
    }

    public final Long peerBgpAsnExtended() {
        return this.peerBgpAsnExtended;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final LocalGatewayVirtualInterfaceConfigurationState configurationState() {
        return LocalGatewayVirtualInterfaceConfigurationState.fromValue(this.configurationState);
    }

    public final String configurationStateAsString() {
        return this.configurationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsnExtended());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterface)) {
            return false;
        }
        LocalGatewayVirtualInterface other = (LocalGatewayVirtualInterface)obj;
        return Objects.equals(this.localGatewayVirtualInterfaceId(), other.localGatewayVirtualInterfaceId()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId()) && Objects.equals(this.localGatewayVirtualInterfaceArn(), other.localGatewayVirtualInterfaceArn()) && Objects.equals(this.outpostLagId(), other.outpostLagId()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.localAddress(), other.localAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.localBgpAsn(), other.localBgpAsn()) && Objects.equals(this.peerBgpAsn(), other.peerBgpAsn()) && Objects.equals(this.peerBgpAsnExtended(), other.peerBgpAsnExtended()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationStateAsString(), other.configurationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LocalGatewayVirtualInterface").add("LocalGatewayVirtualInterfaceId", (Object)this.localGatewayVirtualInterfaceId()).add("LocalGatewayId", (Object)this.localGatewayId()).add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).add("LocalGatewayVirtualInterfaceArn", (Object)this.localGatewayVirtualInterfaceArn()).add("OutpostLagId", (Object)this.outpostLagId()).add("Vlan", (Object)this.vlan()).add("LocalAddress", (Object)this.localAddress()).add("PeerAddress", (Object)this.peerAddress()).add("LocalBgpAsn", (Object)this.localBgpAsn()).add("PeerBgpAsn", (Object)this.peerBgpAsn()).add("PeerBgpAsnExtended", (Object)this.peerBgpAsnExtended()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationState", (Object)this.configurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceId()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
            case "LocalGatewayVirtualInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceArn()));
            }
            case "OutpostLagId": {
                return Optional.ofNullable(clazz.cast(this.outpostLagId()));
            }
            case "Vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "LocalAddress": {
                return Optional.ofNullable(clazz.cast(this.localAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "LocalBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.localBgpAsn()));
            }
            case "PeerBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsn()));
            }
            case "PeerBgpAsnExtended": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsnExtended()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.configurationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocalGatewayVirtualInterfaceId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceArn", LOCAL_GATEWAY_VIRTUAL_INTERFACE_ARN_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("LocalBgpAsn", LOCAL_BGP_ASN_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("PeerBgpAsnExtended", PEER_BGP_ASN_EXTENDED_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterface, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localGatewayVirtualInterfaceId;
        private String localGatewayId;
        private String localGatewayVirtualInterfaceGroupId;
        private String localGatewayVirtualInterfaceArn;
        private String outpostLagId;
        private Integer vlan;
        private String localAddress;
        private String peerAddress;
        private Integer localBgpAsn;
        private Integer peerBgpAsn;
        private Long peerBgpAsnExtended;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String configurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterface model) {
            this.localGatewayVirtualInterfaceId(model.localGatewayVirtualInterfaceId);
            this.localGatewayId(model.localGatewayId);
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            this.localGatewayVirtualInterfaceArn(model.localGatewayVirtualInterfaceArn);
            this.outpostLagId(model.outpostLagId);
            this.vlan(model.vlan);
            this.localAddress(model.localAddress);
            this.peerAddress(model.peerAddress);
            this.localBgpAsn(model.localBgpAsn);
            this.peerBgpAsn(model.peerBgpAsn);
            this.peerBgpAsnExtended(model.peerBgpAsnExtended);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
            this.configurationState(model.configurationState);
        }

        public final String getLocalGatewayVirtualInterfaceId() {
            return this.localGatewayVirtualInterfaceId;
        }

        public final void setLocalGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
            return this;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceArn() {
            return this.localGatewayVirtualInterfaceArn;
        }

        public final void setLocalGatewayVirtualInterfaceArn(String localGatewayVirtualInterfaceArn) {
            this.localGatewayVirtualInterfaceArn = localGatewayVirtualInterfaceArn;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceArn(String localGatewayVirtualInterfaceArn) {
            this.localGatewayVirtualInterfaceArn = localGatewayVirtualInterfaceArn;
            return this;
        }

        public final String getOutpostLagId() {
            return this.outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getLocalAddress() {
            return this.localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Integer getLocalBgpAsn() {
            return this.localBgpAsn;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final Integer getPeerBgpAsn() {
            return this.peerBgpAsn;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final Long getPeerBgpAsnExtended() {
            return this.peerBgpAsnExtended;
        }

        public final void setPeerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
        }

        @Override
        public final Builder peerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationState() {
            return this.configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(LocalGatewayVirtualInterfaceConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public LocalGatewayVirtualInterface build() {
            return new LocalGatewayVirtualInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalGatewayVirtualInterface> {
        public Builder localGatewayVirtualInterfaceId(String var1);

        public Builder localGatewayId(String var1);

        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder localGatewayVirtualInterfaceArn(String var1);

        public Builder outpostLagId(String var1);

        public Builder vlan(Integer var1);

        public Builder localAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder localBgpAsn(Integer var1);

        public Builder peerBgpAsn(Integer var1);

        public Builder peerBgpAsnExtended(Long var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder configurationState(String var1);

        public Builder configurationState(LocalGatewayVirtualInterfaceConfigurationState var1);
    }
}

