/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public class DescribeSpotPriceHistoryPublisher
implements SdkPublisher<DescribeSpotPriceHistoryResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSpotPriceHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSpotPriceHistoryPublisher(Ec2AsyncClient client, DescribeSpotPriceHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSpotPriceHistoryPublisher(Ec2AsyncClient client, DescribeSpotPriceHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSpotPriceHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSpotPriceHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpotPrice> spotPriceHistory() {
        Function<DescribeSpotPriceHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPriceHistory() != null) {
                return response.spotPriceHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSpotPriceHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSpotPriceHistoryResponseFetcher
    implements AsyncPageFetcher<DescribeSpotPriceHistoryResponse> {
        private DescribeSpotPriceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotPriceHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSpotPriceHistoryResponse> nextPage(DescribeSpotPriceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotPriceHistoryPublisher.this.client.describeSpotPriceHistory(DescribeSpotPriceHistoryPublisher.this.firstRequest);
            }
            return DescribeSpotPriceHistoryPublisher.this.client.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)((Object)DescribeSpotPriceHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

