/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.RouteServerEndpointState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServerEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServerEndpoint> {
    private static final SdkField<String> ROUTE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerId").getter(RouteServerEndpoint.getter(RouteServerEndpoint::routeServerId)).setter(RouteServerEndpoint.setter(Builder::routeServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerId").unmarshallLocationName("routeServerId").build()}).build();
    private static final SdkField<String> ROUTE_SERVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerEndpointId").getter(RouteServerEndpoint.getter(RouteServerEndpoint::routeServerEndpointId)).setter(RouteServerEndpoint.setter(Builder::routeServerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointId").unmarshallLocationName("routeServerEndpointId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(RouteServerEndpoint.getter(RouteServerEndpoint::vpcId)).setter(RouteServerEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(RouteServerEndpoint.getter(RouteServerEndpoint::subnetId)).setter(RouteServerEndpoint.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniId").getter(RouteServerEndpoint.getter(RouteServerEndpoint::eniId)).setter(RouteServerEndpoint.setter(Builder::eniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").unmarshallLocationName("eniId").build()}).build();
    private static final SdkField<String> ENI_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniAddress").getter(RouteServerEndpoint.getter(RouteServerEndpoint::eniAddress)).setter(RouteServerEndpoint.setter(Builder::eniAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniAddress").unmarshallLocationName("eniAddress").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouteServerEndpoint.getter(RouteServerEndpoint::stateAsString)).setter(RouteServerEndpoint.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(RouteServerEndpoint.getter(RouteServerEndpoint::failureReason)).setter(RouteServerEndpoint.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").unmarshallLocationName("failureReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RouteServerEndpoint.getter(RouteServerEndpoint::tags)).setter(RouteServerEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ID_FIELD, ROUTE_SERVER_ENDPOINT_ID_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, ENI_ID_FIELD, ENI_ADDRESS_FIELD, STATE_FIELD, FAILURE_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServerEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String routeServerId;
    private final String routeServerEndpointId;
    private final String vpcId;
    private final String subnetId;
    private final String eniId;
    private final String eniAddress;
    private final String state;
    private final String failureReason;
    private final List<Tag> tags;

    private RouteServerEndpoint(BuilderImpl builder) {
        this.routeServerId = builder.routeServerId;
        this.routeServerEndpointId = builder.routeServerEndpointId;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.eniId = builder.eniId;
        this.eniAddress = builder.eniAddress;
        this.state = builder.state;
        this.failureReason = builder.failureReason;
        this.tags = builder.tags;
    }

    public final String routeServerId() {
        return this.routeServerId;
    }

    public final String routeServerEndpointId() {
        return this.routeServerEndpointId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String eniId() {
        return this.eniId;
    }

    public final String eniAddress() {
        return this.eniAddress;
    }

    public final RouteServerEndpointState state() {
        return RouteServerEndpointState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerEndpoint)) {
            return false;
        }
        RouteServerEndpoint other = (RouteServerEndpoint)obj;
        return Objects.equals(this.routeServerId(), other.routeServerId()) && Objects.equals(this.routeServerEndpointId(), other.routeServerEndpointId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniAddress(), other.eniAddress()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServerEndpoint").add("RouteServerId", (Object)this.routeServerId()).add("RouteServerEndpointId", (Object)this.routeServerEndpointId()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("EniId", (Object)this.eniId()).add("EniAddress", (Object)this.eniAddress()).add("State", (Object)this.stateAsString()).add("FailureReason", (Object)this.failureReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerId()));
            }
            case "RouteServerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.routeServerEndpointId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
            case "EniAddress": {
                return Optional.ofNullable(clazz.cast(this.eniAddress()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerId", ROUTE_SERVER_ID_FIELD);
        map.put("RouteServerEndpointId", ROUTE_SERVER_ENDPOINT_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("EniId", ENI_ID_FIELD);
        map.put("EniAddress", ENI_ADDRESS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerEndpoint, T> g) {
        return obj -> g.apply((RouteServerEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routeServerId;
        private String routeServerEndpointId;
        private String vpcId;
        private String subnetId;
        private String eniId;
        private String eniAddress;
        private String state;
        private String failureReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerEndpoint model) {
            this.routeServerId(model.routeServerId);
            this.routeServerEndpointId(model.routeServerEndpointId);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.eniId(model.eniId);
            this.eniAddress(model.eniAddress);
            this.state(model.state);
            this.failureReason(model.failureReason);
            this.tags(model.tags);
        }

        public final String getRouteServerId() {
            return this.routeServerId;
        }

        public final void setRouteServerId(String routeServerId) {
            this.routeServerId = routeServerId;
        }

        @Override
        public final Builder routeServerId(String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        public final String getRouteServerEndpointId() {
            return this.routeServerEndpointId;
        }

        public final void setRouteServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
        }

        @Override
        public final Builder routeServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getEniId() {
            return this.eniId;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final String getEniAddress() {
            return this.eniAddress;
        }

        public final void setEniAddress(String eniAddress) {
            this.eniAddress = eniAddress;
        }

        @Override
        public final Builder eniAddress(String eniAddress) {
            this.eniAddress = eniAddress;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteServerEndpointState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteServerEndpoint build() {
            return new RouteServerEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServerEndpoint> {
        public Builder routeServerId(String var1);

        public Builder routeServerEndpointId(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder eniId(String var1);

        public Builder eniAddress(String var1);

        public Builder state(String var1);

        public Builder state(RouteServerEndpointState var1);

        public Builder failureReason(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

