/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RouteServerBgpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteServerPeerRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateRouteServerPeerRequest> {
    private static final SdkField<String> ROUTE_SERVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerEndpointId").getter(CreateRouteServerPeerRequest.getter(CreateRouteServerPeerRequest::routeServerEndpointId)).setter(CreateRouteServerPeerRequest.setter(Builder::routeServerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointId").unmarshallLocationName("RouteServerEndpointId").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(CreateRouteServerPeerRequest.getter(CreateRouteServerPeerRequest::peerAddress)).setter(CreateRouteServerPeerRequest.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("PeerAddress").build()}).build();
    private static final SdkField<RouteServerBgpOptionsRequest> BGP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BgpOptions").getter(CreateRouteServerPeerRequest.getter(CreateRouteServerPeerRequest::bgpOptions)).setter(CreateRouteServerPeerRequest.setter(Builder::bgpOptions)).constructor(RouteServerBgpOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions").unmarshallLocationName("BgpOptions").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateRouteServerPeerRequest.getter(CreateRouteServerPeerRequest::dryRun)).setter(CreateRouteServerPeerRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateRouteServerPeerRequest.getter(CreateRouteServerPeerRequest::tagSpecifications)).setter(CreateRouteServerPeerRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ENDPOINT_ID_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRouteServerPeerRequest.memberNameToFieldInitializer();
    private final String routeServerEndpointId;
    private final String peerAddress;
    private final RouteServerBgpOptionsRequest bgpOptions;
    private final Boolean dryRun;
    private final List<TagSpecification> tagSpecifications;

    private CreateRouteServerPeerRequest(BuilderImpl builder) {
        super(builder);
        this.routeServerEndpointId = builder.routeServerEndpointId;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String routeServerEndpointId() {
        return this.routeServerEndpointId;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final RouteServerBgpOptionsRequest bgpOptions() {
        return this.bgpOptions;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteServerPeerRequest)) {
            return false;
        }
        CreateRouteServerPeerRequest other = (CreateRouteServerPeerRequest)((Object)obj);
        return Objects.equals(this.routeServerEndpointId(), other.routeServerEndpointId()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.bgpOptions(), other.bgpOptions()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteServerPeerRequest").add("RouteServerEndpointId", (Object)this.routeServerEndpointId()).add("PeerAddress", (Object)this.peerAddress()).add("BgpOptions", (Object)this.bgpOptions()).add("DryRun", (Object)this.dryRun()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.routeServerEndpointId()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "BgpOptions": {
                return Optional.ofNullable(clazz.cast(this.bgpOptions()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerEndpointId", ROUTE_SERVER_ENDPOINT_ID_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("BgpOptions", BGP_OPTIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteServerPeerRequest, T> g) {
        return obj -> g.apply((CreateRouteServerPeerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String routeServerEndpointId;
        private String peerAddress;
        private RouteServerBgpOptionsRequest bgpOptions;
        private Boolean dryRun;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteServerPeerRequest model) {
            super(model);
            this.routeServerEndpointId(model.routeServerEndpointId);
            this.peerAddress(model.peerAddress);
            this.bgpOptions(model.bgpOptions);
            this.dryRun(model.dryRun);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getRouteServerEndpointId() {
            return this.routeServerEndpointId;
        }

        public final void setRouteServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
        }

        @Override
        public final Builder routeServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final RouteServerBgpOptionsRequest.Builder getBgpOptions() {
            return this.bgpOptions != null ? this.bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(RouteServerBgpOptionsRequest.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(RouteServerBgpOptionsRequest bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteServerPeerRequest build() {
            return new CreateRouteServerPeerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteServerPeerRequest> {
        public Builder routeServerEndpointId(String var1);

        public Builder peerAddress(String var1);

        public Builder bgpOptions(RouteServerBgpOptionsRequest var1);

        default public Builder bgpOptions(Consumer<RouteServerBgpOptionsRequest.Builder> bgpOptions) {
            return this.bgpOptions((RouteServerBgpOptionsRequest)((RouteServerBgpOptionsRequest.Builder)RouteServerBgpOptionsRequest.builder().applyMutation(bgpOptions)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

