/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteServerAssociation;
import software.amazon.awssdk.services.ec2.model.RouteServerAssociationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRouteServerAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetRouteServerAssociationsResponse> {
    private static final SdkField<List<RouteServerAssociation>> ROUTE_SERVER_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteServerAssociations").getter(GetRouteServerAssociationsResponse.getter(GetRouteServerAssociationsResponse::routeServerAssociations)).setter(GetRouteServerAssociationsResponse.setter(Builder::routeServerAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerAssociationSet").unmarshallLocationName("routeServerAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteServerAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRouteServerAssociationsResponse.memberNameToFieldInitializer();
    private final List<RouteServerAssociation> routeServerAssociations;

    private GetRouteServerAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerAssociations = builder.routeServerAssociations;
    }

    public final boolean hasRouteServerAssociations() {
        return this.routeServerAssociations != null && !(this.routeServerAssociations instanceof SdkAutoConstructList);
    }

    public final List<RouteServerAssociation> routeServerAssociations() {
        return this.routeServerAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteServerAssociations() ? this.routeServerAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteServerAssociationsResponse)) {
            return false;
        }
        GetRouteServerAssociationsResponse other = (GetRouteServerAssociationsResponse)((Object)obj);
        return this.hasRouteServerAssociations() == other.hasRouteServerAssociations() && Objects.equals(this.routeServerAssociations(), other.routeServerAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"GetRouteServerAssociationsResponse").add("RouteServerAssociations", this.hasRouteServerAssociations() ? this.routeServerAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerAssociations": {
                return Optional.ofNullable(clazz.cast(this.routeServerAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RouteServerAssociation>>> map = new HashMap<String, SdkField<List<RouteServerAssociation>>>();
        map.put("RouteServerAssociationSet", ROUTE_SERVER_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouteServerAssociationsResponse, T> g) {
        return obj -> g.apply((GetRouteServerAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<RouteServerAssociation> routeServerAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteServerAssociationsResponse model) {
            super(model);
            this.routeServerAssociations(model.routeServerAssociations);
        }

        public final List<RouteServerAssociation.Builder> getRouteServerAssociations() {
            List<RouteServerAssociation.Builder> result = RouteServerAssociationsListCopier.copyToBuilder(this.routeServerAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServerAssociations(Collection<RouteServerAssociation.BuilderImpl> routeServerAssociations) {
            this.routeServerAssociations = RouteServerAssociationsListCopier.copyFromBuilder(routeServerAssociations);
        }

        @Override
        public final Builder routeServerAssociations(Collection<RouteServerAssociation> routeServerAssociations) {
            this.routeServerAssociations = RouteServerAssociationsListCopier.copy(routeServerAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerAssociations(RouteServerAssociation ... routeServerAssociations) {
            this.routeServerAssociations(Arrays.asList(routeServerAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerAssociations(Consumer<RouteServerAssociation.Builder> ... routeServerAssociations) {
            this.routeServerAssociations(Stream.of(routeServerAssociations).map(c -> (RouteServerAssociation)((RouteServerAssociation.Builder)RouteServerAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRouteServerAssociationsResponse build() {
            return new GetRouteServerAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRouteServerAssociationsResponse> {
        public Builder routeServerAssociations(Collection<RouteServerAssociation> var1);

        public Builder routeServerAssociations(RouteServerAssociation ... var1);

        public Builder routeServerAssociations(Consumer<RouteServerAssociation.Builder> ... var1);
    }
}

