/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsEntry;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpointAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::id)).setter(VpcEndpointAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("id").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::vpcEndpointId)).setter(VpcEndpointAssociation.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNetworkArn").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::serviceNetworkArn)).setter(VpcEndpointAssociation.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNetworkArn").unmarshallLocationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNetworkName").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::serviceNetworkName)).setter(VpcEndpointAssociation.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNetworkName").unmarshallLocationName("serviceNetworkName").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceAccessibility").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::associatedResourceAccessibility)).setter(VpcEndpointAssociation.setter(Builder::associatedResourceAccessibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceAccessibility").unmarshallLocationName("associatedResourceAccessibility").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::failureReason)).setter(VpcEndpointAssociation.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").unmarshallLocationName("failureReason").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::failureCode)).setter(VpcEndpointAssociation.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").unmarshallLocationName("failureCode").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsEntry").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::dnsEntry)).setter(VpcEndpointAssociation.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsEntry").unmarshallLocationName("dnsEntry").build()}).build();
    private static final SdkField<DnsEntry> PRIVATE_DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsEntry").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::privateDnsEntry)).setter(VpcEndpointAssociation.setter(Builder::privateDnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEntry").unmarshallLocationName("privateDnsEntry").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceArn").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::associatedResourceArn)).setter(VpcEndpointAssociation.setter(Builder::associatedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArn").unmarshallLocationName("associatedResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceConfigurationGroupArn").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::resourceConfigurationGroupArn)).setter(VpcEndpointAssociation.setter(Builder::resourceConfigurationGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationGroupArn").unmarshallLocationName("resourceConfigurationGroupArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VpcEndpointAssociation.getter(VpcEndpointAssociation::tags)).setter(VpcEndpointAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VPC_ENDPOINT_ID_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_NAME_FIELD, ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, DNS_ENTRY_FIELD, PRIVATE_DNS_ENTRY_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD, RESOURCE_CONFIGURATION_GROUP_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcEndpointAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String vpcEndpointId;
    private final String serviceNetworkArn;
    private final String serviceNetworkName;
    private final String associatedResourceAccessibility;
    private final String failureReason;
    private final String failureCode;
    private final DnsEntry dnsEntry;
    private final DnsEntry privateDnsEntry;
    private final String associatedResourceArn;
    private final String resourceConfigurationGroupArn;
    private final List<Tag> tags;

    private VpcEndpointAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.associatedResourceAccessibility = builder.associatedResourceAccessibility;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.dnsEntry = builder.dnsEntry;
        this.privateDnsEntry = builder.privateDnsEntry;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.resourceConfigurationGroupArn = builder.resourceConfigurationGroupArn;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final String associatedResourceAccessibility() {
        return this.associatedResourceAccessibility;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final DnsEntry privateDnsEntry() {
        return this.privateDnsEntry;
    }

    public final String associatedResourceArn() {
        return this.associatedResourceArn;
    }

    public final String resourceConfigurationGroupArn() {
        return this.resourceConfigurationGroupArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceAccessibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociation)) {
            return false;
        }
        VpcEndpointAssociation other = (VpcEndpointAssociation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.associatedResourceAccessibility(), other.associatedResourceAccessibility()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.privateDnsEntry(), other.privateDnsEntry()) && Objects.equals(this.associatedResourceArn(), other.associatedResourceArn()) && Objects.equals(this.resourceConfigurationGroupArn(), other.resourceConfigurationGroupArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEndpointAssociation").add("Id", (Object)this.id()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("AssociatedResourceAccessibility", (Object)this.associatedResourceAccessibility()).add("FailureReason", (Object)this.failureReason()).add("FailureCode", (Object)this.failureCode()).add("DnsEntry", (Object)this.dnsEntry()).add("PrivateDnsEntry", (Object)this.privateDnsEntry()).add("AssociatedResourceArn", (Object)this.associatedResourceArn()).add("ResourceConfigurationGroupArn", (Object)this.resourceConfigurationGroupArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ServiceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "ServiceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "AssociatedResourceAccessibility": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceAccessibility()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "DnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "PrivateDnsEntry": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEntry()));
            }
            case "AssociatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArn()));
            }
            case "ResourceConfigurationGroupArn": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("ServiceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("ServiceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("AssociatedResourceAccessibility", ASSOCIATED_RESOURCE_ACCESSIBILITY_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("DnsEntry", DNS_ENTRY_FIELD);
        map.put("PrivateDnsEntry", PRIVATE_DNS_ENTRY_FIELD);
        map.put("AssociatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        map.put("ResourceConfigurationGroupArn", RESOURCE_CONFIGURATION_GROUP_ARN_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociation, T> g) {
        return obj -> g.apply((VpcEndpointAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String vpcEndpointId;
        private String serviceNetworkArn;
        private String serviceNetworkName;
        private String associatedResourceAccessibility;
        private String failureReason;
        private String failureCode;
        private DnsEntry dnsEntry;
        private DnsEntry privateDnsEntry;
        private String associatedResourceArn;
        private String resourceConfigurationGroupArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociation model) {
            this.id(model.id);
            this.vpcEndpointId(model.vpcEndpointId);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.serviceNetworkName(model.serviceNetworkName);
            this.associatedResourceAccessibility(model.associatedResourceAccessibility);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
            this.dnsEntry(model.dnsEntry);
            this.privateDnsEntry(model.privateDnsEntry);
            this.associatedResourceArn(model.associatedResourceArn);
            this.resourceConfigurationGroupArn(model.resourceConfigurationGroupArn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getAssociatedResourceAccessibility() {
            return this.associatedResourceAccessibility;
        }

        public final void setAssociatedResourceAccessibility(String associatedResourceAccessibility) {
            this.associatedResourceAccessibility = associatedResourceAccessibility;
        }

        @Override
        public final Builder associatedResourceAccessibility(String associatedResourceAccessibility) {
            this.associatedResourceAccessibility = associatedResourceAccessibility;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final DnsEntry.Builder getPrivateDnsEntry() {
            return this.privateDnsEntry != null ? this.privateDnsEntry.toBuilder() : null;
        }

        public final void setPrivateDnsEntry(DnsEntry.BuilderImpl privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry != null ? privateDnsEntry.build() : null;
        }

        @Override
        public final Builder privateDnsEntry(DnsEntry privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return this.associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final String getResourceConfigurationGroupArn() {
            return this.resourceConfigurationGroupArn;
        }

        public final void setResourceConfigurationGroupArn(String resourceConfigurationGroupArn) {
            this.resourceConfigurationGroupArn = resourceConfigurationGroupArn;
        }

        @Override
        public final Builder resourceConfigurationGroupArn(String resourceConfigurationGroupArn) {
            this.resourceConfigurationGroupArn = resourceConfigurationGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VpcEndpointAssociation build() {
            return new VpcEndpointAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpointAssociation> {
        public Builder id(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder serviceNetworkArn(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder associatedResourceAccessibility(String var1);

        public Builder failureReason(String var1);

        public Builder failureCode(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder privateDnsEntry(DnsEntry var1);

        default public Builder privateDnsEntry(Consumer<DnsEntry.Builder> privateDnsEntry) {
            return this.privateDnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(privateDnsEntry)).build());
        }

        public Builder associatedResourceArn(String var1);

        public Builder resourceConfigurationGroupArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

